/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.commons.weaver.privilizer.Field;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer.PrivilizingVisitor;
import org.apache.commons.weaver.privilizer._asm.Label;
import org.apache.commons.weaver.privilizer._asm.Type;
import org.apache.commons.weaver.privilizer._asm.commons.GeneratorAdapter;
import org.apache.commons.weaver.privilizer._asm.commons.Method;
import org.apache.commons.weaver.privilizer._asm.signature.SignatureReader;
import org.apache.commons.weaver.privilizer._asm.signature.SignatureVisitor;
import org.apache.commons.weaver.privilizer._asm.signature.SignatureWriter;
import org.apache.commons.weaver.privilizer._lang3.ArrayUtils;
import org.apache.commons.weaver.privilizer._lang3.Validate;
import org.apache.commons.weaver.privilizer._lang3.builder.Builder;

class ActionGenerator
extends Privilizer.WriteClass
implements Builder<Type> {
    final PrivilizingVisitor owner;
    final Method methd;
    final boolean exc;
    final Type[] exceptions;
    final String simpleName;
    final Type action;
    final Method impl;
    final int index;
    final boolean implIsStatic;
    final Method helper;
    final Type result;
    final Field[] fields;
    private final Type actionInterface;

    ActionGenerator(int access, Method methd, String[] exceptions, PrivilizingVisitor owner) {
        Type[] typeArray;
        Privilizer privilizer = owner.privilizer();
        privilizer.getClass();
        super(3);
        this.methd = methd;
        this.exc = ArrayUtils.isNotEmpty(exceptions);
        if (this.exc) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Type.getType(Exception.class);
        } else {
            typeArray = null;
        }
        this.exceptions = typeArray;
        this.owner = owner;
        this.simpleName = ActionGenerator.generateName(methd);
        this.action = Type.getObjectType(owner.className + '$' + this.simpleName);
        int privilegedAccessIndex = -1;
        String implName = null;
        for (Map.Entry<Method, String> entry : owner.privilegedMethods.entrySet()) {
            ++privilegedAccessIndex;
            if (!entry.getKey().equals(methd)) continue;
            implName = entry.getValue();
            break;
        }
        Validate.validState(implName != null);
        this.index = privilegedAccessIndex;
        this.impl = new Method(implName, methd.getDescriptor());
        this.implIsStatic = Modifier.isStatic(access);
        Type[] args = this.implIsStatic ? methd.getArgumentTypes() : ArrayUtils.insert(0, methd.getArgumentTypes(), owner.target);
        this.helper = new Method(this.privilizer().generateName("access$" + this.index), methd.getReturnType(), args);
        this.result = Privilizer.wrap(methd.getReturnType());
        this.fields = ActionGenerator.fields(args);
        this.actionInterface = Type.getType(this.exc ? PrivilegedExceptionAction.class : PrivilegedAction.class);
    }

    private static String generateName(Method methd) {
        StringBuilder buf = new StringBuilder(methd.getName());
        if (methd.getArgumentTypes().length > 0) {
            buf.append("$$");
            for (Type arg : methd.getArgumentTypes()) {
                buf.append(arg.getDescriptor().replace("[", "arrayOf").replace('/', '_').replace(';', '$'));
            }
        }
        return buf.append("_ACTION").toString();
    }

    private static Field[] fields(Type[] args) {
        Field[] result = new Field[args.length];
        for (int i = 0; i < args.length; ++i) {
            String name = "f" + (i + 1);
            result[i] = new Field(18, name, args[i]);
        }
        return result;
    }

    @Override
    public Type build() {
        this.generateHelper();
        this.begin();
        this.init();
        this.impl();
        this.visitEnd();
        this.owner.privilizer().env.debug("Generated %s implementation %s to call %s#%s", new Object[]{this.actionInterface.getClassName(), this.action.getClassName(), this.owner.target.getClassName(), this.helper});
        return this.action;
    }

    private void generateHelper() {
        this.owner.privilizer().env.debug("Generating static helper method %s.%s to call %s", new Object[]{this.owner.target.getClassName(), this.helper, this.impl});
        GeneratorAdapter mgen = new GeneratorAdapter(4104, this.helper, null, this.exceptions, this.owner);
        mgen.visitCode();
        mgen.loadArgs();
        if (this.implIsStatic) {
            mgen.invokeStatic(this.owner.target, this.impl);
        } else {
            mgen.invokeVirtual(this.owner.target, this.impl);
        }
        mgen.returnValue();
        mgen.endMethod();
    }

    private void begin() {
        this.owner.visitInnerClass(this.action.getInternalName(), this.owner.className, this.simpleName, 10);
        SignatureWriter type = new SignatureWriter();
        SignatureVisitor actionImplemented = type.visitInterface();
        actionImplemented.visitClassType(this.actionInterface.getInternalName());
        SignatureVisitor visitTypeArgument = actionImplemented.visitTypeArgument('=');
        new SignatureReader(Privilizer.wrap(this.methd.getReturnType()).getDescriptor()).accept(visitTypeArgument);
        actionImplemented.visitEnd();
        String signature = type.toString();
        this.visit(49, 4144, this.action.getInternalName(), signature, Type.getType(Object.class).getInternalName(), new String[]{this.actionInterface.getInternalName()});
    }

    private void init() {
        for (Field field : this.fields) {
            this.visitField(field.access, field.name, field.type.getDescriptor(), null, null).visitEnd();
        }
        Method init = new Method("<init>", Type.VOID_TYPE, this.helper.getArgumentTypes());
        GeneratorAdapter mgen = new GeneratorAdapter(0, init, null, Privilizer.EMPTY_TYPE_ARRAY, this);
        mgen.visitCode();
        Label begin = mgen.mark();
        mgen.loadThis();
        mgen.invokeConstructor(Type.getType(Object.class), Method.getMethod("void <init> ()"));
        int arg = 0;
        for (Field field : this.fields) {
            mgen.loadThis();
            mgen.loadArg(arg++);
            mgen.putField(this.action, field.name, field.type);
        }
        mgen.returnValue();
        Label end = mgen.mark();
        mgen.visitLocalVariable("this", this.action.getDescriptor(), null, begin, end, 0);
        arg = 1;
        for (Field field : this.fields) {
            mgen.visitLocalVariable("arg" + arg, field.type.getDescriptor(), null, begin, end, arg++);
        }
        mgen.endMethod();
    }

    private void impl() {
        Method run = Method.getMethod("Object run()");
        GeneratorAdapter mgen = new GeneratorAdapter(1, run, null, this.exceptions, this);
        for (Field field : this.fields) {
            mgen.loadThis();
            mgen.getField(this.action, field.name, field.type);
        }
        mgen.invokeStatic(this.owner.target, this.helper);
        if (this.methd.getReturnType().getSort() < 9) {
            mgen.valueOf(this.methd.getReturnType());
        }
        mgen.returnValue();
        mgen.endMethod();
    }
}

