/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.HttpContent;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class NettyServletOutputStream
extends ServletOutputStream {
    private ByteBufOutputStream out;
    private boolean flushed;

    public NettyServletOutputStream(HttpContent httpContent) {
        this.out = new ByteBufOutputStream(httpContent.content());
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        this.out.write(b, offset, len);
    }

    public void flush() throws IOException {
        this.out.flush();
        this.flushed = true;
    }

    public void resetBuffer() {
        this.out.buffer().clear();
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public int getBufferSize() {
        return this.out.buffer().capacity();
    }

    public boolean isReady() {
        throw new IllegalStateException("Method 'isReady' not yet implemented!");
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new IllegalStateException("Method 'setWriteListener' not yet implemented!");
    }
}

