/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import javax.naming.NamingException;
import org.apache.cxf.transport.jms.util.DestinationResolver;
import org.apache.cxf.transport.jms.util.JndiHelper;

public class JMSDestinationResolver
implements DestinationResolver {
    JndiHelper jndiTemplate;

    @Override
    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        if (this.jndiTemplate != null) {
            try {
                return this.jndiTemplate.lookup(destinationName, Destination.class);
            }
            catch (NamingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (pubSubDomain) {
            return session.createTopic(destinationName);
        }
        return session.createQueue(destinationName);
    }

    public void setJndiTemplate(JndiHelper jt) {
        this.jndiTemplate = jt;
    }
}

