/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.store;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.spi.store.Store;

public abstract class AbstractValueHolder<V>
implements Store.ValueHolder<V> {
    private final long id;
    private final long creationTime;
    private volatile long lastAccessTime;
    private volatile long expirationTime;
    private static final AtomicLongFieldUpdater<AbstractValueHolder> ACCESSTIME_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractValueHolder.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<AbstractValueHolder> EXPIRATIONTIME_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractValueHolder.class, "expirationTime");

    protected AbstractValueHolder(long id, long creationTime) {
        this(id, creationTime, -1L);
    }

    protected AbstractValueHolder(long id, long creationTime, long expirationTime) {
        this.id = id;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.lastAccessTime = creationTime;
    }

    @Override
    public long creationTime() {
        return this.creationTime;
    }

    public void setExpirationTime(long expirationTime) {
        if (expirationTime == -1L) {
            this.updateExpirationTime(-1L);
        } else {
            if (expirationTime < 0L) {
                throw new IllegalArgumentException("invalid expiration time: " + expirationTime);
            }
            this.updateExpirationTime(expirationTime);
        }
    }

    private void updateExpirationTime(long update) {
        long current;
        while ((current = this.expirationTime) < update && !EXPIRATIONTIME_UPDATER.compareAndSet(this, current, update)) {
        }
    }

    public void accessed(long now, Duration expiration) {
        if (expiration != null) {
            if (ExpiryUtils.isExpiryDurationInfinite(expiration)) {
                this.setExpirationTime(-1L);
            } else {
                long newExpirationTime = ExpiryUtils.getExpirationMillis(now, expiration);
                this.setExpirationTime(newExpirationTime);
            }
        }
        this.setLastAccessTime(now);
    }

    @Override
    public long expirationTime() {
        return this.expirationTime;
    }

    @Override
    public boolean isExpired(long expirationTime) {
        long expire = this.expirationTime;
        if (expire == -1L) {
            return false;
        }
        return expire <= expirationTime;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        long current;
        while ((current = this.lastAccessTime) < lastAccessTime && !ACCESSTIME_UPDATER.compareAndSet(this, current, lastAccessTime)) {
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result = 31 * result + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractValueHolder) {
            AbstractValueHolder other = (AbstractValueHolder)obj;
            return other.creationTime == this.creationTime && other.expirationTime == this.expirationTime && other.lastAccessTime == this.lastAccessTime;
        }
        return false;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String toString() {
        return String.format("%s", this.get());
    }
}

