/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.theta.EstimateSketchUDF;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class EstimateSketchUDFTest {
    @Test
    public void evaluateNull() {
        EstimateSketchUDF testObject = new EstimateSketchUDF();
        Double testResult = testObject.evaluate(null);
        AssertJUnit.assertEquals((Object)testResult, (Object)0.0);
    }

    @Test
    public void evaluateEmptyInput() {
        EstimateSketchUDF testObject = new EstimateSketchUDF();
        BytesWritable testInput = new BytesWritable();
        Double testResult = testObject.evaluate(testInput);
        AssertJUnit.assertEquals((Object)testResult, (Object)0.0);
    }

    @Test
    public void evaluateValid() {
        EstimateSketchUDF testObject = new EstimateSketchUDF();
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch.update((long)i);
        }
        BytesWritable input = new BytesWritable(sketch.toByteArray());
        Double testResult = testObject.evaluate(input);
        AssertJUnit.assertEquals((Object)128.0, (Object)testResult);
        CompactSketch compactSketch = sketch.compact(false, null);
        input = new BytesWritable(compactSketch.toByteArray());
        testResult = testObject.evaluate(input);
        AssertJUnit.assertEquals((Object)128.0, (Object)testResult);
    }

    @Test
    public void evaluateValidExplicitSeed() {
        EstimateSketchUDF testObject = new EstimateSketchUDF();
        long seed = 1L;
        UpdateSketch sketch = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch.update((long)i);
        }
        BytesWritable input = new BytesWritable(sketch.toByteArray());
        Double testResult = testObject.evaluate(input, 1L);
        AssertJUnit.assertEquals((Object)128.0, (Object)testResult);
        CompactSketch compactSketch = sketch.compact(false, null);
        input = new BytesWritable(compactSketch.toByteArray());
        testResult = testObject.evaluate(input, 1L);
        AssertJUnit.assertEquals((Object)128.0, (Object)testResult);
    }

    @Test
    public void evaluateRespectsByteLength() {
        byte[] inputBytes = new byte[]{1, 3, 3, 0, 0, 58, -52, -109, 21, -7, 125, -53, -67, -122, -95, 5, 0, 0, 0, 0, 0, 0, 0, 0};
        BytesWritable input = new BytesWritable(inputBytes, 16);
        EstimateSketchUDF estimate = new EstimateSketchUDF();
        Double testResult = estimate.evaluate(input);
        AssertJUnit.assertEquals((double)1.0, (double)testResult, (double)0.0);
    }
}

