/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AllocateDirectWritableMapMemoryTest {
    private static final String LS = System.getProperty("line.separator");

    @BeforeClass
    public void setReadOnly() {
        UtilTest.setGettysburgAddressFileToReadOnly();
    }

    @Test
    public void simpleMap() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try (Memory mem = Memory.map((File)file);){
            byte[] bytes = new byte[(int)mem.getCapacity()];
            mem.getByteArray(0L, bytes, 0, bytes.length);
            String text = new String(bytes, StandardCharsets.UTF_8);
            AllocateDirectWritableMapMemoryTest.println(text);
            try {
                mem.force();
                Assert.fail();
            }
            catch (ReadOnlyException readOnlyException) {
                // empty catch block
            }
        }
    }

    @Test
    public void copyOffHeapToMemoryMappedFile() throws Exception {
        long bytes = 1024L;
        long longs = bytes >>> 3;
        File file = new File("TestFile.bin");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        try (WritableMemory dstMem = WritableMemory.writableMap((File)file, (long)0L, (long)bytes, (ByteOrder)ByteOrder.nativeOrder());
             WritableMemory srcMem = WritableMemory.allocateDirect((long)bytes);){
            for (long i = 0L; i < longs; ++i) {
                srcMem.putLong(i << 3, i);
            }
            srcMem.copyTo(0L, dstMem, 0L, srcMem.getCapacity());
            dstMem.force();
            Assert.assertEquals((long)dstMem.getLong(longs - 1L << 3), (long)(longs - 1L));
        }
    }

    @Test
    public void checkNonNativeFile() throws Exception {
        File file = new File("TestFile2.bin");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        long bytes = 8L;
        try (WritableMemory wmem = WritableMemory.writableMap((File)file, (long)0L, (long)8L, (ByteOrder)Util.NON_NATIVE_BYTE_ORDER);){
            wmem.putChar(0L, '\u0001');
            Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        }
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testMapException() throws IOException {
        File dummy = AllocateDirectWritableMapMemoryTest.createFile("dummy.txt", "");
        Memory.map((File)dummy, (long)0L, (long)dummy.length(), (ByteOrder)ByteOrder.nativeOrder());
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void simpleMap2() throws IOException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((file.canRead() && !file.canWrite() ? 1 : 0) != 0);
        WritableMemory wmem = WritableMemory.writableMap((File)file);
        Throwable throwable = null;
        if (wmem != null) {
            if (throwable != null) {
                try {
                    wmem.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                wmem.close();
            }
        }
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void checkOverLength() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        WritableMemory.writableMap((File)file, (long)0L, (long)0x100000L, (ByteOrder)ByteOrder.nativeOrder());
    }

    @Test
    public void testForce() throws Exception {
        String bufStr;
        byte[] buf;
        String origStr = "Corectng spellng mistks";
        File origFile = AllocateDirectWritableMapMemoryTest.createFile("force_original.txt", origStr);
        Assert.assertTrue((boolean)origFile.setWritable(true, false));
        long origBytes = origFile.length();
        String correctStr = "Correcting spelling mistakes";
        byte[] correctByteArr = correctStr.getBytes(StandardCharsets.UTF_8);
        long corrBytes = correctByteArr.length;
        try (Memory map = Memory.map((File)origFile, (long)0L, (long)origBytes, (ByteOrder)ByteOrder.nativeOrder());){
            map.load();
            Assert.assertTrue((boolean)map.isLoaded());
            buf = new byte[(int)origBytes];
            map.getByteArray(0L, buf, 0, (int)origBytes);
            bufStr = new String(buf, StandardCharsets.UTF_8);
            Assert.assertEquals((String)bufStr, (String)origStr);
        }
        var10_8 = null;
        try (WritableMemory wMap = WritableMemory.writableMap((File)origFile, (long)0L, (long)corrBytes, (ByteOrder)ByteOrder.nativeOrder());){
            wMap.load();
            Assert.assertTrue((boolean)wMap.isLoaded());
            wMap.putByteArray(0L, correctByteArr, 0, (int)corrBytes);
            wMap.force();
            buf = new byte[(int)corrBytes];
            wMap.getByteArray(0L, buf, 0, (int)corrBytes);
            bufStr = new String(buf, StandardCharsets.UTF_8);
            Assert.assertEquals((String)bufStr, (String)correctStr);
        }
        catch (Throwable throwable) {
            var10_8 = throwable;
            throw throwable;
        }
    }

    private static File createFile(String fileName, String text) throws FileNotFoundException {
        File file = new File(fileName);
        file.deleteOnExit();
        try {
            PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8.name());
            writer.print(text);
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return file;
    }

    @Test
    public void printlnTest() {
        AllocateDirectWritableMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectWritableMapMemoryTest.print(LS);
        } else {
            AllocateDirectWritableMapMemoryTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

