/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import org.apache.datasketches.pig.quantiles.GetQuantileFromDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileFromDoublesSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetQuantileFromDoublesSketch func = new GetQuantileFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        Double result = (Double)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0)));
        Assert.assertEquals((double)result, (double)Double.NaN);
    }

    @Test
    public void normalCase() throws Exception {
        GetQuantileFromDoublesSketch func = new GetQuantileFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(1.0);
        Double result = (Double)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertEquals((double)result, (double)1.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetQuantileFromDoublesSketch func = new GetQuantileFromDoublesSketch();
        func.exec(tupleFactory.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantileFromDoublesSketch func = new GetQuantileFromDoublesSketch();
        func.exec(tupleFactory.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFraction() throws Exception {
        GetQuantileFromDoublesSketch func = new GetQuantileFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 1)));
    }
}

