/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;
import org.apache.derby.impl.sql.execute.GenericTriggerExecutor;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.RowTriggerExecutor;
import org.apache.derby.impl.sql.execute.StatementTriggerExecutor;
import org.apache.derby.impl.sql.execute.TriggerEvent;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.shared.common.sanity.SanityManager;

public class TriggerEventActivator {
    private LanguageConnectionContext lcc;
    private TriggerInfo triggerInfo;
    private InternalTriggerExecutionContext tec;
    private GenericTriggerExecutor[][] executors;
    private Activation activation;
    private ConnectionContext cc;
    private String statementText;
    private int dmlType;
    private UUID tableId;
    private String tableName;

    public TriggerEventActivator(LanguageConnectionContext lcc, UUID tableId, TriggerInfo triggerInfo, int dmlType, Activation activation, Vector<AutoincrementCounter> aiCounters) throws StandardException {
        if (triggerInfo == null) {
            return;
        }
        this.tableName = triggerInfo.triggerArray[0].getTableDescriptor().getQualifiedName();
        this.lcc = lcc;
        this.activation = activation;
        this.tableId = tableId;
        this.dmlType = dmlType;
        this.triggerInfo = triggerInfo;
        this.cc = (ConnectionContext)((Object)lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        this.statementText = lcc.getStatementContext().getStatementText();
        this.tec = ((GenericExecutionFactory)lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(lcc, this.cc, this.statementText, dmlType, tableId, this.tableName, aiCounters);
        this.setupExecutors(triggerInfo);
    }

    void reopen() throws StandardException {
        this.tec = ((GenericExecutionFactory)this.lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(this.lcc, this.cc, this.statementText, this.dmlType, this.tableId, this.tableName, null);
        this.setupExecutors(this.triggerInfo);
    }

    private void setupExecutors(TriggerInfo triggerInfo) throws StandardException {
        int i;
        this.executors = new GenericTriggerExecutor[6][];
        ArrayList executorLists = new ArrayList(6);
        for (i = 0; i < 6; ++i) {
            executorLists.add(new ArrayList());
        }
        block6: for (i = 0; i < triggerInfo.triggerArray.length; ++i) {
            TriggerDescriptor td = triggerInfo.triggerArray[i];
            switch (td.getTriggerEventMask()) {
                case 4: {
                    if (td.isBeforeTrigger()) {
                        ((List)executorLists.get(0)).add(td);
                        continue block6;
                    }
                    ((List)executorLists.get(3)).add(td);
                    continue block6;
                }
                case 2: {
                    if (td.isBeforeTrigger()) {
                        ((List)executorLists.get(1)).add(td);
                        continue block6;
                    }
                    ((List)executorLists.get(4)).add(td);
                    continue block6;
                }
                case 1: {
                    if (td.isBeforeTrigger()) {
                        ((List)executorLists.get(2)).add(td);
                        continue block6;
                    }
                    ((List)executorLists.get(5)).add(td);
                    continue block6;
                }
                default: {
                    SanityManager.THROWASSERT("bad trigger event " + td.getTriggerEventMask());
                }
            }
        }
        for (i = 0; i < executorLists.size(); ++i) {
            List descriptors = (List)executorLists.get(i);
            int size = descriptors.size();
            if (size <= 0) continue;
            this.executors[i] = new GenericTriggerExecutor[size];
            for (int j = 0; j < size; ++j) {
                TriggerDescriptor td = (TriggerDescriptor)descriptors.get(j);
                this.executors[i][j] = td.isRowTrigger() ? new RowTriggerExecutor(this.tec, td, this.activation, this.lcc) : new StatementTriggerExecutor(this.tec, td, this.activation, this.lcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(TriggerEvent event, CursorResultSet brs, CursorResultSet ars, int[] colsReadFromTable) throws StandardException {
        if (this.executors == null) {
            return;
        }
        int eventNumber = event.getNumber();
        if (this.executors[eventNumber] == null) {
            return;
        }
        this.tec.setCurrentTriggerEvent(event);
        try {
            if (brs != null) {
                brs.open();
            }
            if (ars != null) {
                ars.open();
            }
            this.lcc.pushExecutionStmtValidator(this.tec);
            for (int i = 0; i < this.executors[eventNumber].length; ++i) {
                if (i > 0) {
                    if (brs != null) {
                        ((NoPutResultSet)((Object)brs)).reopenCore();
                    }
                    if (ars != null) {
                        ((NoPutResultSet)((Object)ars)).reopenCore();
                    }
                }
                this.tec.resetAICounters(true);
                this.executors[eventNumber][i].fireTrigger(event, brs, ars, colsReadFromTable);
            }
        }
        finally {
            this.lcc.popExecutionStmtValidator(this.tec);
            this.tec.clearCurrentTriggerEvent();
        }
    }

    public void cleanup() throws StandardException {
        if (this.tec != null) {
            this.tec.cleanup();
        }
    }
}

