/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class ConnectionHandlingJunit
extends BaseJDBCTestCase {
    public static Writer getLogDiscarder() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public ConnectionHandlingJunit(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ConnectionHandlingJUnit");
        if (JDBC.vmSupportsJDBC3()) {
            ConnectionHandlingJunit nonExistentDbTest = new ConnectionHandlingJunit("driverMgrTestConnectionsToNonexistentDb");
            ConnectionHandlingJunit nonExistentDbTestInMem = new ConnectionHandlingJunit("driverMgrTestConnectionsToNonexistentDbInMemory");
            suite.addTest((Test)nonExistentDbTest);
            suite.addTest((Test)nonExistentDbTestInMem);
        }
        return suite;
    }

    public void driverMgrTestConnectionsToNonexistentDb() throws SQLException {
        String url = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        this.driverMgrConnectionInitiator(url, false);
    }

    public void driverMgrTestConnectionsToNonexistentDbInMemory() throws SQLException {
        this.driverMgrConnectionInitiator("jdbc:derby:memory:noDbHere", true);
    }

    private void driverMgrConnectionInitiator(String url, boolean appendId) throws SQLException {
        Connection myInvalidConn = null;
        this.loadDriver(url);
        Runtime runtime = Runtime.getRuntime();
        int maxCount = 130000;
        int count = 0;
        ConnectionHandlingJunit.println("Trying " + maxCount + " connection attempts...");
        try {
            while (count < maxCount) {
                try {
                    myInvalidConn = DriverManager.getConnection(appendId ? url + count : url);
                    ConnectionHandlingJunit.fail((String)"Got connection to a DB that should not exist");
                }
                catch (SQLException e) {
                    String expectedState;
                    if (this.getTestConfiguration().getJDBCClient().isEmbedded()) {
                        expectedState = "XJ004";
                        if (e.getSQLState().equals("08004") && e.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + count + " connection attempts to a non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(e);
                        }
                    } else {
                        expectedState = "08004";
                        if (e.getSQLState().equals("XJ001") && e.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + count + " connection attempts to a non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(e);
                        }
                    }
                    ConnectionHandlingJunit.assertSQLState("Wrong SQLState for non-existent database", expectedState, e);
                }
                if (!this.getTestConfiguration().isVerbose() || ++count % 1000 != 0) continue;
                double memTotalNow = (double)runtime.totalMemory() / 1048576.0;
                ConnectionHandlingJunit.println("Iteration: " + count + "\tTotal memory (MB): " + memTotalNow);
            }
        }
        catch (OutOfMemoryError oome) {
            ConnectionHandlingJunit.alarm("OutOfMemory after " + count + " connection attempts!");
            ConnectionHandlingJunit.alarm(oome.getMessage());
            throw oome;
        }
    }

    private void loadDriver(String url) throws SQLException {
        ConnectionHandlingJunit.setSystemProperty("derby.stream.error.method", "org.apache.derbyTesting.functionTests.tests.memory.ConnectionHandlingJunit.getLogDiscarder");
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            ConnectionHandlingJunit.assertSQLState("Unexpected SQLState from getDriver().", "08001", e);
            ConnectionHandlingJunit.assertEquals((String)"Unexpected exception message from getDriver(), ", (String)"No suitable driver", (String)e.getMessage());
            String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            ConnectionHandlingJunit.println("Loading JDBC driver " + driverClass);
            try {
                Class<?> clazz = Class.forName(driverClass);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', ClassNotFoundException: " + cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', IllegalAccessException: " + iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', InstantiationException: " + ie.getMessage());
            }
            catch (NoSuchMethodException ie) {
                throw new SQLException("Missing constructor for JDBC driver '" + driverClass + "', NoSuchMethodException: " + ie.getMessage());
            }
            catch (InvocationTargetException ie) {
                throw new SQLException("Could not invoke the constructor for JDBC driver '" + driverClass + "', InvocationTargetException: " + ie.getMessage());
            }
        }
    }
}

