/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SQLToJUnit {
    private static final int DEFAULT_LEFT_MARGIN = 8;
    private static String leftMargin;
    private static final String IJ_COMMENT = "--";
    private static final String IJ_WARNING = "ij warning";
    private static final String JAVA_COMMENT = "//";
    private static final String RS_META_OBJECT_NAME = "rsmd";
    private static final String RS_OBJECT_NAME = "rs";
    private static final String CSTMT_OBJECT_NAME = "cSt";
    private static final String PSTMT_OBJECT_NAME = "pSt";
    private static final String SQL_WARN_OBJECT_NAME = "sqlWarn";
    private static String IJ_PROMPT;
    private static String CONN_OBJECT_NAME;
    private static String STMT_OBJECT_NAME;
    private static String USER_NAME;
    private static String getWarningLogic;
    private static final String[] DDL_NO_RC_COMMANDS;
    private static final String[] DDL_RC_COMMANDS;
    private static final String[] QUERY_COMMANDS;
    private static final String[] IJ_COMMANDS;
    private static int EXEC_QUERY;
    private static int EXEC_DDL_NO_ROW_COUNT;
    private static int EXEC_DDL_WITH_ROW_COUNT;
    private static int PREPARE;
    private static int P_EXECUTE;
    private static int CALL_STMT;
    private static int COMMENT;
    private static int AUTOCOMMIT;
    private static int COMMIT;
    private static int ROLLBACK;
    private static int SET_SCHEMA;
    private static int REMOVE;
    private static int GRANT;
    private static int GET_CURSOR;
    private static int CURSOR_NEXT;
    private static int CURSOR_CLOSE;
    private static int CONNECT;
    private static int SET_CONNECTION;
    private static int REVOKE;
    private static int IJ_COMMAND;
    private static int ROW_COUNT;
    private static int BLANK_LINE;
    private static int SQL_ERROR;
    private static int SQL_WARNING;
    private static int IWARNING;
    private static int UNKNOWN_LINE;
    private static int LINE_LENGTH;
    private int prevLineType;
    private String jTestName;
    private BufferedReader ijScript;
    private BufferedWriter junit;
    private StringBuffer tmpBuf;
    private boolean gotRuntimeStatistics = false;
    private int numIgnored = 0;
    private int numUnconverted = 0;
    private boolean multipleUserConnections = false;
    private Properties userConnections = new Properties();
    private int usersConnected;
    private int anonymousCount = 0;

    public static void main(String[] args) {
        try {
            new SQLToJUnit().convert(args);
        }
        catch (Exception e) {
            System.out.println("OOPS, top-level error:");
            e.printStackTrace();
        }
    }

    public void convert(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("\n  Usage:  java SQLToJUnit <embedded_sql_out_file>\n");
            return;
        }
        if (!this.loadIJScript(args[0])) {
            return;
        }
        this.writePrologue();
        this.tmpBuf = new StringBuffer();
        try {
            leftMargin = "";
            for (int i = 0; i < 8; ++i) {
                leftMargin = leftMargin + " ";
            }
            this.writeJUnitEOL();
            boolean done = false;
            StringBuffer currLine = new StringBuffer();
            StringBuffer nextLine = new StringBuffer();
            StringBuffer str = new StringBuffer();
            while (!done && this.getNextIjCommand(str)) {
                int nextLineType = this.getLineType(str);
                if (nextLineType == SET_CONNECTION) {
                    CONN_OBJECT_NAME = str.substring(str.indexOf("set connection ") + 15, str.length());
                    STMT_OBJECT_NAME = "st_" + CONN_OBJECT_NAME;
                    IJ_PROMPT = "ij(" + CONN_OBJECT_NAME.toUpperCase() + ")>";
                    USER_NAME = this.userConnections.getProperty(CONN_OBJECT_NAME);
                    this.junit.write("// set connection " + CONN_OBJECT_NAME);
                    this.writeJUnitEOL();
                }
                while (this.ignorableLine(nextLineType)) {
                    if (nextLineType != BLANK_LINE) {
                        this.junit.write("[**:: IGNORED ::**] ");
                        this.junit.write(str.toString().trim());
                        this.writeJUnitEOL();
                        this.writeJUnitEOL();
                        ++this.numIgnored;
                    }
                    str.delete(0, str.length());
                    if (!this.getNextIjCommand(str)) {
                        done = true;
                        break;
                    }
                    nextLineType = this.getLineType(str);
                }
                boolean writeCurrLine = true;
                if (nextLineType == COMMENT) {
                    if (this.prevLineType == COMMENT) {
                        nextLine.append(this.strip(str, IJ_COMMENT));
                        writeCurrLine = false;
                    } else {
                        nextLine.append(str.toString().trim());
                        boolean bl = writeCurrLine = currLine.length() > 0;
                    }
                }
                if (writeCurrLine && (nextLineType != SQL_ERROR || this.prevLineType != SQL_ERROR)) {
                    if (nextLineType != COMMENT) {
                        nextLine.append(str);
                    }
                    this.writeJavaLine(currLine, nextLine);
                    if (nextLine.length() == 0) {
                        this.writeJUnitEOL();
                    }
                }
                this.prevLineType = nextLineType;
                str.delete(0, str.length());
                currLine.append(nextLine.toString());
                nextLine.delete(0, nextLine.length());
            }
            if (currLine.length() > 0) {
                this.writeJavaLine(currLine, nextLine);
            }
            this.writeJUnitEOL();
            this.junit.write("getConnection().rollback();");
            this.writeJUnitEOL();
            this.junit.write("st.close();");
            this.junit.write("\n    }\n}");
            System.out.println("\n  ==> Ignored " + this.numIgnored + " lines and left " + this.numUnconverted + " lines unconverted.\n  ==> Output is in '" + this.jTestName + ".junit'.\n\n");
            if (this.multipleUserConnections) {
                System.out.print("Found multiple users: ");
                Enumeration<Object> e = this.userConnections.elements();
                while (e.hasMoreElements()) {
                    System.out.print("\"");
                    System.out.print(e.nextElement());
                    System.out.print("\"");
                    System.out.print(e.hasMoreElements() ? ", " : "");
                }
            }
            System.out.println("\n\nDone.\n");
            this.junit.flush();
        }
        catch (Exception e) {
            if (this.junit != null) {
                this.junit.flush();
            }
            throw e;
        }
    }

    private boolean loadIJScript(String fName) throws Exception {
        try {
            this.ijScript = new BufferedReader(new InputStreamReader(new FileInputStream(fName)));
            this.jTestName = fName.endsWith(".out") ? fName.substring(0, fName.indexOf(".")) : fName;
            this.jTestName = this.jTestName.replaceAll("[.]", "_");
            this.junit = new BufferedWriter(new FileWriter(this.jTestName + ".junit"));
        }
        catch (IOException ioe) {
            System.out.println("-=- Could not find IJ master: '" + fName + "'");
            return false;
        }
        return true;
    }

    private void writeJavaLine(StringBuffer lineToWrite, StringBuffer followupLine) throws Exception {
        if (lineToWrite == null || lineToWrite.length() == 0) {
            return;
        }
        boolean writeEOL = true;
        this.strip(lineToWrite, IJ_PROMPT);
        if (this.prevLineType == COMMENT) {
            this.strip(lineToWrite, IJ_COMMENT);
            this.junit.write(JAVA_COMMENT);
            this.writeMaxLenLine(lineToWrite, "// ", null);
            this.writeJUnitEOL();
        } else if (this.prevLineType == IJ_COMMAND) {
            this.junit.write("[**:: UNCONVERTED ::**] ");
            this.junit.write(lineToWrite.toString());
            this.writeJUnitEOL();
            ++this.numUnconverted;
        } else if (this.prevLineType >= 0) {
            this.writeJDBCCode(lineToWrite, followupLine);
        } else if (this.prevLineType == SQL_WARNING) {
            this.writeAssertWarning(lineToWrite);
            this.writeJUnitEOL();
        } else {
            String str = lineToWrite.toString();
            if (str.trim().length() > 0) {
                this.junit.write("[**:: UNCONVERTED ::**] ");
                this.junit.write(str);
                this.writeJUnitEOL();
                ++this.numUnconverted;
            } else {
                writeEOL = false;
            }
        }
        if (writeEOL) {
            this.writeJUnitEOL();
        }
        lineToWrite.delete(0, lineToWrite.length());
    }

    private void writeJDBCCode(StringBuffer stmt, StringBuffer result) throws Exception {
        int resultType = this.getLineType(result);
        boolean success = resultType != SQL_ERROR;
        String indent = "";
        if (!success) {
            indent = "    ";
        }
        if (this.prevLineType == EXEC_QUERY) {
            if (success) {
                this.junit.write("rs = ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(".executeQuery(");
                this.writeJUnitEOL();
                this.writeQuotedLine(stmt, indent);
                this.writeJUnitEOL();
                this.writeAssertResultSet(result);
            } else {
                this.writeFailStatement(stmt, null, result, false);
            }
        } else if (this.prevLineType == EXEC_DDL_WITH_ROW_COUNT || this.prevLineType == EXEC_DDL_NO_ROW_COUNT) {
            if (success) {
                if (resultType == ROW_COUNT && this.prevLineType == EXEC_DDL_WITH_ROW_COUNT) {
                    this.writeAssertDDLCount(stmt, result, STMT_OBJECT_NAME);
                } else {
                    this.junit.write(STMT_OBJECT_NAME);
                    this.junit.write(".executeUpdate(");
                    this.writeJUnitEOL();
                    this.writeQuotedLine(stmt, indent);
                    result.delete(0, result.length());
                }
            } else {
                this.writeFailStatement(stmt, null, result, false);
            }
        } else if (this.prevLineType == PREPARE) {
            stmt.delete(0, stmt.indexOf("'") + 1);
            stmt.delete(stmt.lastIndexOf("'"), stmt.length());
            if (success) {
                this.junit.write(indent);
                this.junit.write(PSTMT_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write("prepareStatement(");
                this.writeJUnitEOL();
                this.writeQuotedLine(stmt, indent);
                this.writeJUnitEOL();
            } else {
                this.writeFailStatement(stmt, null, result, true);
            }
        } else if (this.prevLineType == P_EXECUTE) {
            if (stmt.indexOf("'") != -1) {
                stmt.delete(0, stmt.indexOf("'") + 1);
                stmt.delete(stmt.lastIndexOf("'"), stmt.length());
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(".executeQuery(");
                this.writeJUnitEOL();
                this.collapseQuotes(stmt, '\'');
                this.writeQuotedLine(stmt, indent);
                this.writeJUnitEOL();
                this.writeJUnitEOL();
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".next();");
                this.writeJUnitEOL();
                this.junit.write(RS_META_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".getMetaData();");
                this.writeJUnitEOL();
                this.junit.write("for (int i = 1; i <= ");
                this.junit.write(RS_META_OBJECT_NAME);
                this.junit.write(".getColumnCount(); i++)");
                this.writeJUnitEOL();
                this.junit.write("    ");
                this.junit.write(PSTMT_OBJECT_NAME);
                this.junit.write(".setObject(i, ");
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".getObject(i));");
                this.writeJUnitEOL();
                this.writeJUnitEOL();
            }
            if (success) {
                if (resultType == ROW_COUNT) {
                    this.writeAssertDDLCount(null, result, PSTMT_OBJECT_NAME);
                } else {
                    this.junit.write("rs = ");
                    this.junit.write(PSTMT_OBJECT_NAME);
                    this.junit.write(".executeQuery();");
                    this.writeAssertResultSet(result);
                }
            } else {
                this.writeFailStatement(null, PSTMT_OBJECT_NAME, result, false);
            }
        } else if (this.prevLineType == CALL_STMT) {
            this.junit.write(CSTMT_OBJECT_NAME);
            this.junit.write(" = prepareCall(");
            this.writeJUnitEOL();
            this.writeQuotedLine(stmt, "");
            if (success) {
                this.writeJUnitEOL();
                this.writeAssertDDLCount(null, result, CSTMT_OBJECT_NAME);
            } else {
                this.writeJUnitEOL();
                this.writeFailStatement(null, CSTMT_OBJECT_NAME, result, false);
            }
        } else if (this.prevLineType == AUTOCOMMIT) {
            this.junit.write(CONN_OBJECT_NAME + ".setAutoCommit(");
            this.junit.write(stmt.indexOf(" off") == -1 ? "true" : "false");
            this.junit.write(");");
            this.writeJUnitEOL();
        } else if (this.prevLineType == COMMIT) {
            this.junit.write(CONN_OBJECT_NAME + ".commit();");
        } else if (this.prevLineType == ROLLBACK) {
            this.junit.write(CONN_OBJECT_NAME + ".rollback();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == GET_CURSOR) {
            this.writeGetCursor(stmt, indent);
        } else if (this.prevLineType == CURSOR_NEXT) {
            this.junit.write(stmt.substring(stmt.lastIndexOf(" ") + 1));
            this.junit.write(".next();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == CURSOR_CLOSE) {
            String cName = stmt.substring(stmt.lastIndexOf(" ") + 1).trim();
            this.junit.write(cName);
            this.junit.write(".close();");
            this.writeJUnitEOL();
            this.junit.write("ps_");
            this.junit.write(cName);
            this.junit.write(".close();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == CONNECT) {
            this.multipleUserConnections = true;
            int userpos = 0;
            boolean anonymous = false;
            if (stmt.indexOf("user=") > 0) {
                userpos = stmt.indexOf("user=") + 4;
                if (stmt.indexOf(" as ") < 0) {
                    anonymous = true;
                }
            } else {
                userpos = stmt.indexOf("'", stmt.indexOf("user") + 1);
            }
            if (anonymous) {
                CONN_OBJECT_NAME = "CONNECTION" + this.anonymousCount;
                ++this.anonymousCount;
            } else {
                int connpos = stmt.indexOf(" as ");
                CONN_OBJECT_NAME = stmt.substring(connpos + 4, stmt.length());
            }
            STMT_OBJECT_NAME = "st_" + CONN_OBJECT_NAME;
            USER_NAME = stmt.substring(userpos + 1, stmt.indexOf("'", userpos + 1));
            if (this.userConnections.get(USER_NAME) == null) {
                this.junit.write("Connection ");
                this.junit.write(CONN_OBJECT_NAME);
                this.junit.write(" = openUserConnection(\"");
                this.junit.write(USER_NAME);
                this.junit.write("\");");
                this.writeJUnitEOL();
                this.junit.write("Statement ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(CONN_OBJECT_NAME);
                this.junit.write(".createStatement();");
                this.writeJUnitEOL();
            }
            this.userConnections.setProperty(CONN_OBJECT_NAME, USER_NAME);
            ++this.usersConnected;
            if (this.usersConnected > 1) {
                IJ_PROMPT = "ij(" + CONN_OBJECT_NAME.toUpperCase() + ")>";
            }
        }
    }

    private void writeFailStatement(StringBuffer stmt, String stmtName, StringBuffer result, boolean compileTime) throws Exception {
        String sqlState = this.extractSQLState(result);
        if (compileTime) {
            this.junit.write("assertCompileError(\"");
        } else {
            this.junit.write("assertStatementError(\"");
        }
        this.junit.write(sqlState);
        this.junit.write("\", ");
        if (stmt != null) {
            if (!compileTime) {
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(",");
            }
            this.writeJUnitEOL();
            this.writeQuotedLine(stmt, "");
        } else {
            this.junit.write(stmtName);
            this.junit.write(");");
        }
    }

    private void writeAssertDDLCount(StringBuffer stmt, StringBuffer ddlCount, String stmtName) throws Exception {
        this.junit.write("assertUpdateCount(");
        this.junit.write(stmtName);
        this.junit.write(", ");
        this.junit.write(this.extractRowCount(ddlCount));
        if (stmt != null) {
            this.junit.write(",");
            this.writeJUnitEOL();
            this.writeQuotedLine(stmt, "");
        } else {
            this.junit.write(");");
        }
    }

    private String extractRowCount(StringBuffer sBuf) throws Exception {
        int lineType = this.getLineType(sBuf);
        if (lineType != ROW_COUNT) {
            System.out.println("OOPS, tried to extract row count from " + sBuf);
            return "";
        }
        String rowCount = sBuf.substring(0, sBuf.indexOf(" ")).trim();
        sBuf.delete(0, sBuf.length());
        return rowCount;
    }

    private void writeGetCursor(StringBuffer stmt, String indent) throws Exception {
        int pos_2;
        int pos_1 = stmt.indexOf("cursor") + 7;
        if (pos_1 < 0) {
            pos_1 = stmt.indexOf("CURSOR") + 7;
        }
        if ((pos_2 = stmt.indexOf(" as ")) < 0) {
            pos_2 = stmt.indexOf(" AS ");
        }
        String cName = stmt.substring(pos_1, pos_2).trim();
        this.junit.write("PreparedStatement ps_");
        this.junit.write(cName);
        this.junit.write(" = prepareStatement(");
        this.writeJUnitEOL();
        stmt.delete(0, stmt.indexOf("'") + 1);
        stmt.delete(stmt.lastIndexOf("'"), stmt.length());
        this.collapseQuotes(stmt, '\'');
        this.writeQuotedLine(stmt, indent);
        this.writeJUnitEOL();
        this.writeJUnitEOL();
        this.junit.write("ResultSet ");
        this.junit.write(cName);
        this.junit.write(" = ps_");
        this.junit.write(cName);
        this.junit.write(".executeQuery();");
        this.writeJUnitEOL();
    }

    private void writeMaxLenLine(StringBuffer aLine, String prefix, String suffix) throws Exception {
        if (aLine.length() <= LINE_LENGTH) {
            this.junit.write(aLine.toString());
            return;
        }
        int prefixLen = prefix == null ? 0 : prefix.length();
        int suffixLen = suffix == null ? 0 : suffix.length();
        int pos = -1;
        boolean firstLine = true;
        while (aLine.length() > 0) {
            if (!firstLine) {
                this.writeJUnitEOL();
                if (prefixLen > 0) {
                    this.junit.write(prefix);
                }
            }
            if ((pos = aLine.indexOf("\n")) != -1) {
                this.writeMaxLenLine(new StringBuffer(aLine.substring(0, pos)), prefix, suffix);
                ++pos;
            } else if (aLine.length() <= LINE_LENGTH) {
                this.junit.write(aLine.toString());
                pos = aLine.length();
            } else {
                String s = aLine.toString().substring(0, LINE_LENGTH - prefixLen - suffixLen);
                pos = s.lastIndexOf(" ") + 1;
                if (pos == 0) {
                    pos = s.length();
                }
                this.junit.write(s.substring(0, pos));
            }
            aLine.delete(0, pos);
            if (suffixLen > 0 && aLine.length() > 0) {
                this.junit.write(suffix);
            }
            firstLine = false;
        }
    }

    private void escapeQuotes(StringBuffer aLine) {
        if (aLine == null || aLine.length() == 0) {
            return;
        }
        int len = aLine.length();
        for (int i = len - 1; i >= 0; --i) {
            if (aLine.charAt(i) != '\"') continue;
            aLine.replace(i, i + 1, "\\\"");
        }
    }

    private void collapseQuotes(StringBuffer aLine, char quote) {
        if (aLine == null || aLine.length() == 0) {
            return;
        }
        int len = aLine.length();
        for (int i = len - 1; i >= 1; --i) {
            if (aLine.charAt(i) != quote || aLine.charAt(i - 1) != quote) continue;
            aLine.deleteCharAt(i);
            --i;
        }
    }

    private String strip(String str, String toStrip) {
        if (toStrip == null || toStrip.length() == 0) {
            return str;
        }
        if (!str.trim().startsWith(toStrip)) {
            return str;
        }
        return str.substring(str.indexOf(toStrip) + toStrip.length()).trim();
    }

    private StringBuffer strip(StringBuffer sBuf, String toStrip) {
        if (toStrip == null || toStrip.length() == 0) {
            return sBuf;
        }
        if (sBuf.length() == 0) {
            return sBuf;
        }
        int pos = 0;
        while (Character.isWhitespace(sBuf.charAt(pos))) {
            ++pos;
        }
        int len = toStrip.length();
        boolean okayToStrip = true;
        for (int i = 0; i < len && okayToStrip; ++i) {
            if (sBuf.charAt(pos + i) == toStrip.charAt(i)) continue;
            okayToStrip = false;
        }
        if (okayToStrip) {
            sBuf.delete(0, pos + len);
        }
        return sBuf;
    }

    private int getLineType(StringBuffer sBuf) {
        return this.getLineType(sBuf.toString());
    }

    private int getLineType(String str) {
        if ((str = this.strip(str, IJ_PROMPT).toLowerCase().trim()).length() == 0) {
            return BLANK_LINE;
        }
        if (str.startsWith(IJ_WARNING)) {
            return IWARNING;
        }
        if (str.startsWith(IJ_COMMENT)) {
            return COMMENT;
        }
        if (str.startsWith("error")) {
            return SQL_ERROR;
        }
        if (str.startsWith("warning")) {
            return SQL_WARNING;
        }
        if (this.isIjCommand(str)) {
            return IJ_COMMAND;
        }
        if (this.isQueryStatement(str)) {
            return EXEC_QUERY;
        }
        if (this.isDDLWithRowCount(str)) {
            return EXEC_DDL_WITH_ROW_COUNT;
        }
        if (this.isDDLNoRowCount(str)) {
            return EXEC_DDL_NO_ROW_COUNT;
        }
        if (str.startsWith("prepare")) {
            return PREPARE;
        }
        if (str.startsWith("execute")) {
            return P_EXECUTE;
        }
        if (str.startsWith("call ")) {
            return CALL_STMT;
        }
        if (Character.isDigit(str.charAt(0))) {
            int pos = str.indexOf(" ");
            if (pos > 0 && str.substring(pos).trim().startsWith("row")) {
                return ROW_COUNT;
            }
            return UNKNOWN_LINE;
        }
        if (str.startsWith("autocommit")) {
            return AUTOCOMMIT;
        }
        if (str.startsWith("commit")) {
            return COMMIT;
        }
        if (str.startsWith("rollback")) {
            return ROLLBACK;
        }
        if (str.startsWith("set schema")) {
            return SET_SCHEMA;
        }
        if (str.startsWith("grant ")) {
            return GRANT;
        }
        if (str.startsWith("revoke")) {
            return REVOKE;
        }
        if (str.startsWith("remove")) {
            return REMOVE;
        }
        if (str.startsWith("get cursor")) {
            return GET_CURSOR;
        }
        if (str.startsWith("next ")) {
            return CURSOR_NEXT;
        }
        if (str.startsWith("close")) {
            return CURSOR_CLOSE;
        }
        if (str.startsWith("connect")) {
            return CONNECT;
        }
        if (str.startsWith("set connection")) {
            return SET_CONNECTION;
        }
        return UNKNOWN_LINE;
    }

    private boolean isDDLWithRowCount(String str) {
        for (int i = 0; i < DDL_RC_COMMANDS.length; ++i) {
            if (!str.startsWith(DDL_RC_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDDLNoRowCount(String str) {
        for (int i = 0; i < DDL_NO_RC_COMMANDS.length; ++i) {
            if (!str.startsWith(DDL_NO_RC_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isQueryStatement(String str) {
        for (int i = 0; i < QUERY_COMMANDS.length; ++i) {
            if (!str.startsWith(QUERY_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isIjCommand(String str) {
        for (int i = 0; i < IJ_COMMANDS.length; ++i) {
            if (!str.startsWith(IJ_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private void writeAssertResultSet(StringBuffer rsAsText) throws Exception {
        while (rsAsText.length() > 0 && Character.isWhitespace(rsAsText.charAt(0))) {
            rsAsText.deleteCharAt(0);
        }
        BufferedReader rsReader = new BufferedReader(new StringReader(rsAsText.toString()));
        int rowCount = 0;
        int colCount = 0;
        boolean wroteDecl = false;
        StringBuffer sBuf = new StringBuffer();
        StringTokenizer tkzr = null;
        String row = rsReader.readLine();
        while (row != null) {
            if (rowCount != 1) {
                if (this.getLineType(row) == ROW_COUNT) {
                    --rowCount;
                } else {
                    if (rowCount == 0) {
                        this.writeJUnitEOL();
                        this.junit.write("expColNames = new String [] {");
                    } else if (!wroteDecl) {
                        this.writeJUnitEOL();
                        this.junit.write("expRS = new String [][]");
                        this.writeJUnitEOL();
                        this.junit.write("{");
                        wroteDecl = true;
                    }
                    if (rowCount > 2) {
                        this.junit.write(",");
                    }
                    colCount = 0;
                    tkzr = new StringTokenizer(row, "|");
                    if (rowCount > 0) {
                        this.writeJUnitEOL();
                        this.junit.write("    {");
                    }
                    while (tkzr.hasMoreTokens()) {
                        sBuf.append(tkzr.nextToken().trim());
                        this.escapeQuotes(sBuf);
                        if (colCount > 0) {
                            this.junit.write(", ");
                        }
                        if (sBuf.toString().equals("NULL")) {
                            this.junit.write("null");
                        } else {
                            this.junit.write("\"");
                            this.writeMaxLenLine(sBuf, "        + \"", "\"");
                            this.junit.write("\"");
                        }
                        ++colCount;
                        sBuf.delete(0, sBuf.length());
                    }
                    this.junit.write("}");
                    if (rowCount == 0) {
                        this.junit.write(";");
                        this.writeJUnitEOL();
                        this.junit.write("JDBC.assertColumnNames(rs, expColNames);");
                        this.writeJUnitEOL();
                    }
                }
            }
            row = rsReader.readLine();
            ++rowCount;
        }
        if (rowCount == 2) {
            this.junit.write("JDBC.assertDrainResults(rs, 0);");
        } else {
            this.writeJUnitEOL();
            this.junit.write("};");
            this.writeJUnitEOL();
            this.writeJUnitEOL();
            this.junit.write("JDBC.assertFullResultSet(rs, expRS, true);");
        }
        rsAsText.delete(0, rsAsText.length());
    }

    private String extractSQLState(StringBuffer errString) throws Exception {
        String sqlState;
        if (errString.indexOf("SQLSTATE") > 0) {
            sqlState = errString.delete(0, errString.indexOf(" ", errString.indexOf("SQLSTATE")) + 1).toString().substring(0, 5);
            errString.delete(0, 6);
        } else {
            sqlState = errString.substring(errString.indexOf(" ") + 1, errString.indexOf(":"));
            errString.delete(0, errString.length());
        }
        return sqlState;
    }

    private void writeAssertSQLState(String sqlState, String objName) throws Exception {
        this.junit.write("assertSQLState(\"");
        this.junit.write(sqlState);
        this.junit.write("\", ");
        this.junit.write(objName);
        this.junit.write(");");
    }

    private void writeAssertWarning(StringBuffer warnString) throws Exception {
        String indent = "    ";
        if (getWarningLogic == null) {
            getWarningLogic = "if (usingEmbedded())\n" + leftMargin + "{\n" + leftMargin + indent + "if ((sqlWarn == null) && (" + STMT_OBJECT_NAME + " != null))\n" + leftMargin + indent + indent + "sqlWarn = " + STMT_OBJECT_NAME + ".getWarnings();\n" + leftMargin + indent + "if (sqlWarn == null)\n" + leftMargin + indent + indent + "sqlWarn = " + (this.multipleUserConnections ? CONN_OBJECT_NAME : "getConnection()") + ".getWarnings();\n" + leftMargin;
        }
        this.junit.write(getWarningLogic);
        this.junit.write(indent);
        this.junit.write("assertNotNull(\"Expected warning but found none\", ");
        this.junit.write(SQL_WARN_OBJECT_NAME);
        this.junit.write(");");
        this.writeJUnitEOL();
        this.junit.write(indent);
        this.writeAssertSQLState(this.extractSQLState(warnString), SQL_WARN_OBJECT_NAME);
        this.writeJUnitEOL();
        this.junit.write(indent);
        this.junit.write("sqlWarn = null;");
        this.writeJUnitEOL();
        this.junit.write("}");
    }

    private void writeQuotedLine(StringBuffer line, String indent) throws Exception {
        this.junit.write(indent);
        this.junit.write("    \"");
        this.escapeQuotes(line);
        this.writeMaxLenLine(line, indent + "    + \"", "\"");
        this.junit.write("\");");
    }

    private void writeJUnitEOL() throws IOException {
        this.junit.write("\n");
        this.junit.write(leftMargin);
    }

    private boolean getNextIjCommand(StringBuffer aLine) throws IOException {
        int c = 0;
        boolean done = false;
        StringBuffer targetBuf = aLine;
        String nextline = null;
        boolean insideRS = false;
        boolean gotFirstComment = false;
        boolean gotCommand = false;
        boolean readFromTmpBuf = false;
        if (this.tmpBuf.length() > 0) {
            nextline = this.tmpBuf.toString();
            this.tmpBuf.delete(0, this.tmpBuf.length());
            readFromTmpBuf = true;
        }
        while (!done) {
            if (!readFromTmpBuf) {
                nextline = this.ijScript.readLine();
            } else {
                readFromTmpBuf = false;
            }
            while (nextline != null && (nextline = nextline.trim()).length() == 0) {
                nextline = this.ijScript.readLine();
            }
            if (nextline == null) {
                c = -1;
                break;
            }
            int linetype = this.getLineType(nextline);
            if (!insideRS) {
                boolean bl = gotCommand = gotCommand || linetype > -1 && linetype != COMMENT;
            }
            if (!insideRS && nextline.charAt(nextline.length() - 1) == ';') {
                targetBuf.append(nextline.substring(0, nextline.length() - 1));
                if (nextline.indexOf("GET_RUNTIMESTATISTICS()") <= 0) break;
                this.gotRuntimeStatistics = true;
                break;
            }
            if (!gotCommand && (linetype == UNKNOWN_LINE || linetype == COMMENT && !gotFirstComment && insideRS)) {
                insideRS = true;
                if (linetype == COMMENT) {
                    gotFirstComment = true;
                }
                targetBuf.append(nextline);
                targetBuf.append("\n");
                continue;
            }
            if (insideRS) {
                if (linetype > -1) {
                    if (this.gotRuntimeStatistics) {
                        this.gotRuntimeStatistics = false;
                        targetBuf.append(nextline);
                        targetBuf.append("\n");
                        continue;
                    }
                    this.tmpBuf.append(nextline);
                    break;
                }
                targetBuf.append(nextline);
                break;
            }
            targetBuf.append(nextline);
            if (!gotCommand) break;
            targetBuf.append(" ");
        }
        return c != -1;
    }

    private boolean haveNonCommand(String aLine) {
        int lType = this.getLineType(aLine);
        return lType < 0 || lType == COMMENT;
    }

    private boolean ignorableLine(int lineType) {
        return lineType == IWARNING || lineType == BLANK_LINE;
    }

    private void writePrologue() throws IOException {
        String prologueText = "\npublic final class IJToJUnitTest extends BaseJDBCTestCase {\n\n    /**\n     * Public constructor required for running test as standalone JUnit.\n     */\n    public IJToJUnitTest(String name)\n    {\n        super(name);\n    }\n\n    public static Test suite()\n    {\n        BaseTestSuite suite = new BaseTestSuite(\"IJToJUnitTest Test\");\n        suite.addTest(TestConfiguration.defaultSuite(IJToJUnitTest.class));\n        return suite;\n    }\n\n    public void test_IJToJUnitTest() throws Exception\n    {\n        ResultSet rs = null;\n        ResultSetMetaData rsmd;\n        SQLWarning sqlWarn = null;\n\n        PreparedStatement pSt;\n        CallableStatement cSt;\n        Statement st = createStatement();\n\n        String [][] expRS;\n        String [] expColNames;\n\n";
        this.junit.write("\npublic final class IJToJUnitTest extends BaseJDBCTestCase {\n\n    /**\n     * Public constructor required for running test as standalone JUnit.\n     */\n    public IJToJUnitTest(String name)\n    {\n        super(name);\n    }\n\n    public static Test suite()\n    {\n        BaseTestSuite suite = new BaseTestSuite(\"IJToJUnitTest Test\");\n        suite.addTest(TestConfiguration.defaultSuite(IJToJUnitTest.class));\n        return suite;\n    }\n\n    public void test_IJToJUnitTest() throws Exception\n    {\n        ResultSet rs = null;\n        ResultSetMetaData rsmd;\n        SQLWarning sqlWarn = null;\n\n        PreparedStatement pSt;\n        CallableStatement cSt;\n        Statement st = createStatement();\n\n        String [][] expRS;\n        String [] expColNames;\n\n".replaceAll("IJToJUnitTest", this.jTestName));
    }

    static {
        IJ_PROMPT = "ij>";
        CONN_OBJECT_NAME = "conn";
        STMT_OBJECT_NAME = "st";
        USER_NAME = "";
        DDL_NO_RC_COMMANDS = new String[]{"create", "drop", "alter", "insert", "rename", "grant ", "set schema", "revoke", "lock table"};
        DDL_RC_COMMANDS = new String[]{"update", "delete", "declare"};
        QUERY_COMMANDS = new String[]{"select", "values"};
        IJ_COMMANDS = new String[]{"show", "describe"};
        EXEC_QUERY = 0;
        EXEC_DDL_NO_ROW_COUNT = 1;
        EXEC_DDL_WITH_ROW_COUNT = 2;
        PREPARE = 3;
        P_EXECUTE = 4;
        CALL_STMT = 5;
        COMMENT = 6;
        AUTOCOMMIT = 7;
        COMMIT = 8;
        ROLLBACK = 9;
        SET_SCHEMA = 10;
        REMOVE = 11;
        GRANT = 12;
        GET_CURSOR = 13;
        CURSOR_NEXT = 14;
        CURSOR_CLOSE = 15;
        CONNECT = 16;
        SET_CONNECTION = 17;
        REVOKE = 18;
        IJ_COMMAND = 19;
        ROW_COUNT = -1;
        BLANK_LINE = -3;
        SQL_ERROR = -4;
        SQL_WARNING = -5;
        IWARNING = -7;
        UNKNOWN_LINE = -999;
        LINE_LENGTH = 60;
    }
}

