/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SystemAggregator;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class CountAggregator
extends SystemAggregator {
    private long value;
    private boolean isCountStar;

    @Override
    public void setup(ClassFactory cf, String aggregateName, DataTypeDescriptor returnType) {
        this.isCountStar = aggregateName.equals("COUNT(*)");
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        SanityManager.ASSERT(addend instanceof CountAggregator, "addend is supposed to be the same type of aggregator for the merge operator");
        this.value += ((CountAggregator)addend).value;
    }

    @Override
    public DataValueDescriptor getResult() {
        return new SQLLongint(this.value);
    }

    @Override
    public void accumulate(DataValueDescriptor addend, Object ga) throws StandardException {
        if (this.isCountStar) {
            ++this.value;
        } else {
            super.accumulate(addend, ga);
        }
    }

    @Override
    protected final void accumulate(DataValueDescriptor addend) {
        ++this.value;
    }

    @Override
    public ExecAggregator newAggregator() {
        CountAggregator ca = new CountAggregator();
        ca.isCountStar = this.isCountStar;
        return ca;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isCountStar);
        out.writeLong(this.value);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isCountStar = in.readBoolean();
        this.value = in.readLong();
    }

    @Override
    public int getTypeFormatId() {
        return 151;
    }
}

