/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformer;

public class GetterSetterNameTransformer
implements SourceTransformer {
    private static Logger log = Logger.getLogger(GetterSetterNameTransformer.class);
    private static Camelbacker camelbacker = new Camelbacker();
    private String attributeName = "name";
    private String getterNameAttribute = "getterName";
    private String setterNameAttribute = "setterName";

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("attributeName must not be null");
        }
        this.attributeName = attributeName;
    }

    public String getGetterNameAttribute() {
        return this.getterNameAttribute;
    }

    public void setGetterNameAttribute(String getterNameAttribute) {
        if (getterNameAttribute == null) {
            throw new NullPointerException("getterNameAttribute must not be null");
        }
        this.getterNameAttribute = getterNameAttribute;
    }

    public String getSetterNameAttribute() {
        return this.setterNameAttribute;
    }

    public void setSetterNameAttribute(String setterNameAttribute) {
        if (setterNameAttribute == null) {
            throw new NullPointerException("setterNameAttribute must not be null");
        }
        this.setterNameAttribute = setterNameAttribute;
    }

    public SourceElement transform(SourceElement sourceElement, ControllerState controllerState) {
        Object attributeValue = sourceElement.getAttribute(this.attributeName);
        if (attributeValue == null) {
            log.debug((Object)("Attribute " + this.attributeName + " is not set, no changes made"));
            return sourceElement;
        }
        String attributeValueString = attributeValue.toString();
        if (StringUtils.isBlank((String)attributeValueString)) {
            log.debug((Object)("Attribute " + this.attributeName + " is blank, no changes made"));
            return sourceElement;
        }
        String getterName = "get" + camelbacker.process(attributeValueString);
        sourceElement.setAttribute(this.getterNameAttribute, (Object)getterName);
        String setterName = "set" + camelbacker.process(attributeValueString);
        sourceElement.setAttribute(this.setterNameAttribute, (Object)setterName);
        return sourceElement;
    }

    static {
        camelbacker.setDefaultLowerCase(false);
    }
}

