/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.typemapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.torque.templates.typemapping.JavaType;
import org.apache.torque.templates.typemapping.ResultSetGetter;
import org.apache.torque.templates.typemapping.SchemaType;

public final class TypeMap {
    private static final Set<SchemaType> TEXT_TYPES;
    public static final String CHAR_OBJECT_TYPE = "\"\"";
    public static final String VARCHAR_OBJECT_TYPE = "\"\"";
    public static final String LONGVARCHAR_OBJECT_TYPE = "\"\"";
    public static final String CLOB_OBJECT_TYPE = "\"\"";
    public static final String NUMERIC_OBJECT_TYPE = "new java.math.BigDecimal((double) 0)";
    public static final String DECIMAL_OBJECT_TYPE = "new java.math.BigDecimal((double) 0)";
    public static final String BIT_OBJECT_TYPE = "Boolean.TRUE";
    public static final String TINYINT_OBJECT_TYPE = "Byte.valueOf((byte) 0)";
    public static final String SMALLINT_OBJECT_TYPE = "Short.valueOf((short) 0)";
    public static final String INTEGER_OBJECT_TYPE = "Integer.valueOf(0)";
    public static final String BIGINT_OBJECT_TYPE = "Long.valueOf(0)";
    public static final String REAL_OBJECT_TYPE = "new Float(0)";
    public static final String FLOAT_OBJECT_TYPE = "new Double(0)";
    public static final String DOUBLE_OBJECT_TYPE = "new Double(0)";
    public static final String BINARY_OBJECT_TYPE = "new Object()";
    public static final String VARBINARY_OBJECT_TYPE = "new Object()";
    public static final String LONGVARBINARY_OBJECT_TYPE = "new Object()";
    public static final String BLOB_OBJECT_TYPE = "new Object()";
    public static final String DATE_OBJECT_TYPE = "new Date()";
    public static final String TIME_OBJECT_TYPE = "new Date()";
    public static final String TIMESTAMP_OBJECT_TYPE = "new Date()";
    public static final String BOOLEANCHAR_OBJECT_TYPE = "\"\"";
    public static final String BOOLEANINT_OBJECT_TYPE = "Integer.valueOf(0)";
    private static final Map<SchemaType, String> SCHEMA_TYPE_TO_INIT_VALUE_MAP;
    private static final Map<SchemaType, JavaType> SCHEMA_TYPE_TO_JAVA_PRIMITIVE_TYPE_MAP;
    private static final Map<SchemaType, JavaType> SCHEMA_TYPE_TO_JAVA_OBJECT_TYPE_MAP;
    private static Map<SchemaType, ResultSetGetter> SCHEMA_TYPE_TO_RESULT_SET_GETTER;

    private TypeMap() {
    }

    public static String getJavaObject(SchemaType jdbcType) {
        return SCHEMA_TYPE_TO_INIT_VALUE_MAP.get((Object)jdbcType);
    }

    public static JavaType getJavaPrimitiveType(SchemaType schemaType) {
        return SCHEMA_TYPE_TO_JAVA_PRIMITIVE_TYPE_MAP.get((Object)schemaType);
    }

    public static JavaType getJavaObjectType(SchemaType schemaType) {
        return SCHEMA_TYPE_TO_JAVA_OBJECT_TYPE_MAP.get((Object)schemaType);
    }

    public static ResultSetGetter getResultSetGetter(SchemaType schemaType) {
        return SCHEMA_TYPE_TO_RESULT_SET_GETTER.get((Object)schemaType);
    }

    public static boolean isBooleanInt(SchemaType type) {
        return SchemaType.BOOLEANINT.equals((Object)type);
    }

    public static boolean isBooleanChar(SchemaType type) {
        return SchemaType.BOOLEANCHAR.equals((Object)type);
    }

    public static boolean isBit(SchemaType type) {
        return SchemaType.BIT.equals((Object)type);
    }

    public static boolean isTextType(SchemaType type) {
        return TEXT_TYPES.contains((Object)type);
    }

    static {
        HashSet<SchemaType> textTypes = new HashSet<SchemaType>();
        textTypes.add(SchemaType.CHAR);
        textTypes.add(SchemaType.VARCHAR);
        textTypes.add(SchemaType.LONGVARCHAR);
        textTypes.add(SchemaType.CLOB);
        textTypes.add(SchemaType.DATE);
        textTypes.add(SchemaType.TIME);
        textTypes.add(SchemaType.TIMESTAMP);
        textTypes.add(SchemaType.BOOLEANCHAR);
        TEXT_TYPES = Collections.unmodifiableSet(textTypes);
        HashMap<SchemaType, String> schemaToInitValue = new HashMap<SchemaType, String>();
        schemaToInitValue.put(SchemaType.CHAR, "\"\"");
        schemaToInitValue.put(SchemaType.VARCHAR, "\"\"");
        schemaToInitValue.put(SchemaType.LONGVARCHAR, "\"\"");
        schemaToInitValue.put(SchemaType.CLOB, "\"\"");
        schemaToInitValue.put(SchemaType.NUMERIC, "new java.math.BigDecimal((double) 0)");
        schemaToInitValue.put(SchemaType.DECIMAL, "new java.math.BigDecimal((double) 0)");
        schemaToInitValue.put(SchemaType.BIT, BIT_OBJECT_TYPE);
        schemaToInitValue.put(SchemaType.TINYINT, TINYINT_OBJECT_TYPE);
        schemaToInitValue.put(SchemaType.SMALLINT, SMALLINT_OBJECT_TYPE);
        schemaToInitValue.put(SchemaType.INTEGER, "Integer.valueOf(0)");
        schemaToInitValue.put(SchemaType.BIGINT, BIGINT_OBJECT_TYPE);
        schemaToInitValue.put(SchemaType.REAL, REAL_OBJECT_TYPE);
        schemaToInitValue.put(SchemaType.FLOAT, "new Double(0)");
        schemaToInitValue.put(SchemaType.DOUBLE, "new Double(0)");
        schemaToInitValue.put(SchemaType.BINARY, "new Object()");
        schemaToInitValue.put(SchemaType.VARBINARY, "new Object()");
        schemaToInitValue.put(SchemaType.LONGVARBINARY, "new Object()");
        schemaToInitValue.put(SchemaType.BLOB, "new Object()");
        schemaToInitValue.put(SchemaType.DATE, "new Date()");
        schemaToInitValue.put(SchemaType.TIME, "new Date()");
        schemaToInitValue.put(SchemaType.TIMESTAMP, "new Date()");
        schemaToInitValue.put(SchemaType.BOOLEANCHAR, "\"\"");
        schemaToInitValue.put(SchemaType.BOOLEANINT, "Integer.valueOf(0)");
        SCHEMA_TYPE_TO_INIT_VALUE_MAP = Collections.unmodifiableMap(schemaToInitValue);
        HashMap<SchemaType, JavaType> schemaToJava = new HashMap<SchemaType, JavaType>();
        schemaToJava.put(SchemaType.CHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.VARCHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.LONGVARCHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.CLOB, JavaType.STRING);
        schemaToJava.put(SchemaType.NUMERIC, JavaType.BIG_DECIMAL);
        schemaToJava.put(SchemaType.DECIMAL, JavaType.BIG_DECIMAL);
        schemaToJava.put(SchemaType.BIT, JavaType.BOOLEAN_PRIMITIVE);
        schemaToJava.put(SchemaType.TINYINT, JavaType.BYTE_PRIMITIVE);
        schemaToJava.put(SchemaType.SMALLINT, JavaType.SHORT_PRIMITIVE);
        schemaToJava.put(SchemaType.INTEGER, JavaType.INTEGER_PRIMITIVE);
        schemaToJava.put(SchemaType.BIGINT, JavaType.LONG_PRIMITIVE);
        schemaToJava.put(SchemaType.REAL, JavaType.FLOAT_PRIMITIVE);
        schemaToJava.put(SchemaType.FLOAT, JavaType.DOUBLE_PRIMITIVE);
        schemaToJava.put(SchemaType.DOUBLE, JavaType.DOUBLE_PRIMITIVE);
        schemaToJava.put(SchemaType.BINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.VARBINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.LONGVARBINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.BLOB, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.DATE, JavaType.DATE);
        schemaToJava.put(SchemaType.TIME, JavaType.DATE);
        schemaToJava.put(SchemaType.TIMESTAMP, JavaType.DATE);
        schemaToJava.put(SchemaType.BOOLEANCHAR, JavaType.BOOLEAN_PRIMITIVE);
        schemaToJava.put(SchemaType.BOOLEANINT, JavaType.BOOLEAN_PRIMITIVE);
        SCHEMA_TYPE_TO_JAVA_PRIMITIVE_TYPE_MAP = Collections.unmodifiableMap(schemaToJava);
        schemaToJava = new HashMap();
        schemaToJava.put(SchemaType.CHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.VARCHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.LONGVARCHAR, JavaType.STRING);
        schemaToJava.put(SchemaType.CLOB, JavaType.STRING);
        schemaToJava.put(SchemaType.NUMERIC, JavaType.BIG_DECIMAL);
        schemaToJava.put(SchemaType.DECIMAL, JavaType.BIG_DECIMAL);
        schemaToJava.put(SchemaType.BIT, JavaType.BOOLEAN_OBJECT);
        schemaToJava.put(SchemaType.TINYINT, JavaType.BYTE_OBJECT);
        schemaToJava.put(SchemaType.SMALLINT, JavaType.SHORT_OBJECT);
        schemaToJava.put(SchemaType.INTEGER, JavaType.INTEGER_OBJECT);
        schemaToJava.put(SchemaType.BIGINT, JavaType.LONG_OBJECT);
        schemaToJava.put(SchemaType.REAL, JavaType.FLOAT_OBJECT);
        schemaToJava.put(SchemaType.FLOAT, JavaType.DOUBLE_OBJECT);
        schemaToJava.put(SchemaType.DOUBLE, JavaType.DOUBLE_OBJECT);
        schemaToJava.put(SchemaType.BINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.VARBINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.LONGVARBINARY, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.BLOB, JavaType.BYTE_PRIMITIVE_ARRAY);
        schemaToJava.put(SchemaType.DATE, JavaType.DATE);
        schemaToJava.put(SchemaType.TIME, JavaType.DATE);
        schemaToJava.put(SchemaType.TIMESTAMP, JavaType.DATE);
        schemaToJava.put(SchemaType.BOOLEANCHAR, JavaType.BOOLEAN_OBJECT);
        schemaToJava.put(SchemaType.BOOLEANINT, JavaType.BOOLEAN_OBJECT);
        SCHEMA_TYPE_TO_JAVA_OBJECT_TYPE_MAP = Collections.unmodifiableMap(schemaToJava);
        HashMap<SchemaType, ResultSetGetter> schemaToResultSetGetter = new HashMap<SchemaType, ResultSetGetter>();
        schemaToResultSetGetter.put(SchemaType.CHAR, ResultSetGetter.STRING);
        schemaToResultSetGetter.put(SchemaType.VARCHAR, ResultSetGetter.STRING);
        schemaToResultSetGetter.put(SchemaType.LONGVARCHAR, ResultSetGetter.STRING);
        schemaToResultSetGetter.put(SchemaType.CLOB, ResultSetGetter.STRING);
        schemaToResultSetGetter.put(SchemaType.NUMERIC, ResultSetGetter.BIG_DECIMAL);
        schemaToResultSetGetter.put(SchemaType.DECIMAL, ResultSetGetter.BIG_DECIMAL);
        schemaToResultSetGetter.put(SchemaType.BIT, ResultSetGetter.BOOLEAN);
        schemaToResultSetGetter.put(SchemaType.TINYINT, ResultSetGetter.BYTE);
        schemaToResultSetGetter.put(SchemaType.SMALLINT, ResultSetGetter.SHORT);
        schemaToResultSetGetter.put(SchemaType.INTEGER, ResultSetGetter.INT);
        schemaToResultSetGetter.put(SchemaType.BIGINT, ResultSetGetter.LONG);
        schemaToResultSetGetter.put(SchemaType.REAL, ResultSetGetter.FLOAT);
        schemaToResultSetGetter.put(SchemaType.FLOAT, ResultSetGetter.DOUBLE);
        schemaToResultSetGetter.put(SchemaType.DOUBLE, ResultSetGetter.DOUBLE);
        schemaToResultSetGetter.put(SchemaType.BINARY, ResultSetGetter.BYTES);
        schemaToResultSetGetter.put(SchemaType.VARBINARY, ResultSetGetter.BYTES);
        schemaToResultSetGetter.put(SchemaType.LONGVARBINARY, ResultSetGetter.BYTES);
        schemaToResultSetGetter.put(SchemaType.BLOB, ResultSetGetter.BYTES);
        schemaToResultSetGetter.put(SchemaType.DATE, ResultSetGetter.DATE);
        schemaToResultSetGetter.put(SchemaType.TIME, ResultSetGetter.TIME);
        schemaToResultSetGetter.put(SchemaType.TIMESTAMP, ResultSetGetter.TIMESTAMP);
        schemaToResultSetGetter.put(SchemaType.BOOLEANCHAR, ResultSetGetter.STRING);
        schemaToResultSetGetter.put(SchemaType.BOOLEANINT, ResultSetGetter.INT);
        SCHEMA_TYPE_TO_RESULT_SET_GETTER = Collections.unmodifiableMap(schemaToResultSetGetter);
    }
}

