/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.stream.CombinedFileSource;
import org.apache.torque.generator.source.stream.FileSource;
import org.apache.torque.generator.source.stream.StreamSourceFormat;

public class FileSourceProvider
extends SourceProvider {
    private static Log log = LogFactory.getLog(FileSourceProvider.class);
    private StreamSourceFormat sourceFormat;
    private Fileset sourceFileset;
    private Boolean combineFiles;
    private List<File> paths;
    private Iterator<File> pathIt;
    private Set<StreamSourceFormat> streamSourceFormats;
    private ControllerState controllerState;

    public FileSourceProvider(StreamSourceFormat sourceFormat, Fileset sourceFileset, Boolean combineFiles) throws ConfigurationException {
        if (sourceFileset == null) {
            throw new NullPointerException("sourceFileset must not be null");
        }
        this.sourceFormat = sourceFormat;
        this.sourceFileset = sourceFileset;
        this.combineFiles = combineFiles;
    }

    @Override
    protected void initInternal(ConfigurationHandlers configurationHandlers, ControllerState controllerState) throws ConfigurationException {
        if (controllerState == null) {
            throw new NullPointerException("controllerState must not be null");
        }
        this.controllerState = controllerState;
        if (this.sourceFileset.getBasedir() == null) {
            throw new ConfigurationException("Basedir of sourceFileset must not be null");
        }
        try {
            this.paths = this.sourceFileset.getFiles();
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        log.debug((Object)("initInternal(): " + this.paths.size() + " matching files found."));
        this.pathIt = this.paths.iterator();
        this.streamSourceFormats = configurationHandlers.getStreamSourceFormats();
    }

    @Override
    public void resetInternal(ConfigurationHandlers configurationHandlers, ControllerState controllerState) {
        this.paths = null;
        this.pathIt = null;
        this.streamSourceFormats = null;
        this.controllerState = null;
    }

    @Override
    public boolean hasNext() {
        if (!this.isInit()) {
            throw new IllegalStateException("init() must be called on this SourceProvider before hasNext can be called");
        }
        return this.pathIt.hasNext();
    }

    @Override
    public Source next() {
        if (!this.isInit()) {
            throw new IllegalStateException("init() must be called on this SourceProvider before hasNext can be called");
        }
        if (this.combineFiles == null || !this.combineFiles.booleanValue()) {
            return this.getNextFileSource();
        }
        ArrayList<FileSource> fileSources = new ArrayList<FileSource>();
        while (this.pathIt.hasNext()) {
            fileSources.add(this.getNextFileSource());
        }
        return new CombinedFileSource(fileSources);
    }

    private FileSource getNextFileSource() {
        File currentPath = this.pathIt.next();
        StreamSourceFormat currentSourceFormat = this.sourceFormat;
        if (currentSourceFormat == null) {
            for (StreamSourceFormat candidate : this.streamSourceFormats) {
                String filenameExtension = candidate.getFilenameExtension();
                if (filenameExtension == null || !currentPath.getName().endsWith("." + filenameExtension)) continue;
                currentSourceFormat = candidate;
                break;
            }
        }
        if (currentSourceFormat == null) {
            throw new RuntimeException("format is not set and file extension is unknown for file " + currentPath.getAbsolutePath());
        }
        return new FileSource(currentSourceFormat, currentPath, this.controllerState);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(sourceFileset=").append(this.sourceFileset).append(",sourceFormat=").append(this.sourceFormat).append(")");
        return result.toString();
    }

    public StreamSourceFormat getSourceFormat() {
        return this.sourceFormat;
    }

    public Fileset getSourceFileset() {
        return this.sourceFileset;
    }

    public void setSourceFileset(Fileset sourceFileset) {
        if (sourceFileset == null) {
            throw new NullPointerException("sourceFileset is null");
        }
        if (this.isInit()) {
            throw new IllegalStateException("Source files are already determined");
        }
        this.sourceFileset = sourceFileset;
    }

    public List<File> getPaths() {
        if (!this.isInit()) {
            throw new IllegalStateException("init() must be called on this SourceProvider before hasNext can be called");
        }
        return Collections.unmodifiableList(this.paths);
    }

    public Boolean getCombineFiles() {
        return this.combineFiles;
    }

    @Override
    public SourceProvider copy() throws ConfigurationException {
        FileSourceProvider result = new FileSourceProvider(this.sourceFormat, this.sourceFileset, this.combineFiles);
        return result;
    }

    @Override
    public void copyNotSetSettingsFrom(SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            return;
        }
        if (!(sourceProvider instanceof FileSourceProvider)) {
            return;
        }
        FileSourceProvider fileSourceProvider = (FileSourceProvider)sourceProvider;
        if (this.combineFiles == null) {
            log.debug((Object)"copying combineFiles property from other source provider");
            this.combineFiles = fileSourceProvider.getCombineFiles();
        }
    }
}

