/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;

final class FindHelper {
    private FindHelper() {
    }

    public static SourceElement findTable(SourceElement root, String tableName, boolean searchExternalSchemata) {
        if (!TorqueSchemaElementName.DATABASE.getName().equals(root.getName())) {
            throw new IllegalArgumentException("Wrong source element " + root.getName());
        }
        for (SourceElement table : root.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
            if (!tableName.equals(table.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME))) continue;
            return table;
        }
        if (searchExternalSchemata) {
            for (SourceElement externalSchema : root.getChildren((SourceElementName)TorqueSchemaElementName.EXTERNAL_SCHEMA)) {
                SourceElement databaseElement = externalSchema.getChild((SourceElementName)TorqueSchemaElementName.DATABASE);
                SourceElement result = FindHelper.findTable(databaseElement, tableName, searchExternalSchemata);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static SourceElement findColumn(SourceElement table, String columnName) {
        if (!TorqueSchemaElementName.TABLE.getName().equals(table.getName())) {
            throw new IllegalArgumentException("Wrong source element " + table.getName());
        }
        for (SourceElement column : table.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN)) {
            if (!column.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME).equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public static List<SourceElement> findForeignKeyByReferencedTable(SourceElement table, String tableName) {
        ArrayList<SourceElement> result = new ArrayList<SourceElement>();
        if (!TorqueSchemaElementName.TABLE.getName().equals(table.getName())) {
            throw new IllegalArgumentException("Wrong source element " + table.getName());
        }
        for (SourceElement foreignKey : table.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
            if (!foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE).equals(tableName)) continue;
            result.add(foreignKey);
        }
        return result;
    }
}

