/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.processor.string;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.torque.generator.processor.string.StringProcessor;

public class RemoveUnusedImportsProcessor
implements StringProcessor {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^import .*\\.[^\r\n\\.]*$", 8);

    @Override
    public String process(String toProcess) {
        Matcher matcher = IMPORT_PATTERN.matcher(toProcess);
        HashMap<String, String> importsForClasses = new HashMap<String, String>();
        while (matcher.find()) {
            Object importLine = matcher.group();
            String className = ((String)importLine).substring(((String)importLine).lastIndexOf(".") + 1);
            int indexOfSemicolon = className.lastIndexOf(59);
            if (indexOfSemicolon == -1) continue;
            int endPos = matcher.end();
            if (toProcess.length() > endPos) {
                char followingChar = toProcess.charAt(endPos);
                importLine = followingChar == '\r' && toProcess.charAt(endPos + 1) == '\n' ? (String)importLine + followingChar + "\n" : (String)importLine + followingChar;
            }
            className = className.substring(0, indexOfSemicolon).trim();
            importsForClasses.put(className, (String)importLine);
        }
        String result = toProcess;
        boolean doNextRun = true;
        while (doNextRun) {
            doNextRun = false;
            Iterator entryIt = importsForClasses.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry importForClassEntry = entryIt.next();
                String className = (String)importForClassEntry.getKey();
                if (result.indexOf(className) != result.lastIndexOf(className)) continue;
                result = result.replace((CharSequence)importForClassEntry.getValue(), "");
                doNextRun = true;
                entryIt.remove();
            }
        }
        return result;
    }
}

