/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Role;

@XmlRootElement(name="fortSet")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="sdset", propOrder={"name", "id", "description", "cardinality", "members", "type"})
public class SDSet
extends FortEntity
implements Serializable,
Comparable<SDSet> {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private Integer cardinality;
    private Set<String> members;
    private SDType type;

    public SDType getType() {
        return this.type;
    }

    public void setType(SDType type) {
        this.type = type;
    }

    private static Set<String> createMembers() {
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId() {
        UUID uuid = UUID.randomUUID();
        this.id = uuid.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Integer cardinality) {
        this.cardinality = cardinality;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members = members;
    }

    public void setMember(String member) {
        if (this.members == null) {
            this.members = new HashSet<String>();
        }
        this.members.add(member);
    }

    public void addMember(String role) {
        if (this.members == null) {
            this.members = SDSet.createMembers();
        }
        this.members.add(role);
    }

    public void delMember(String role) {
        if (this.members == null) {
            return;
        }
        this.members.remove(role);
    }

    @Override
    public int compareTo(SDSet that) {
        return this.name.compareToIgnoreCase(that.getName());
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getName() == null) {
            return false;
        }
        if (thatObj instanceof Role) {
            return false;
        }
        SDSet thatSet = (SDSet)thatObj;
        if (thatSet.getName() == null) {
            return false;
        }
        return thatSet.getName().equalsIgnoreCase(this.getName());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.cardinality != null ? this.cardinality.hashCode() : 0);
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SDSet{name='" + this.name + "'}";
    }

    @XmlType(name="sdtype")
    @XmlEnum
    public static enum SDType {
        STATIC,
        DYNAMIC;

    }
}

