/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import org.apache.directory.fortress.core.util.Config;
import org.jasypt.util.text.BasicTextEncryptor;

public final class EncryptUtil {
    private BasicTextEncryptor textEncryptor;
    private static final String CRYPTO_PROP = "crypto.prop";
    private static volatile EncryptUtil sINSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<EncryptUtil> clazz = EncryptUtil.class;
        synchronized (EncryptUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new EncryptUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private void init() {
        this.textEncryptor = new BasicTextEncryptor();
        this.textEncryptor.setPassword(Config.getInstance().getProperty(CRYPTO_PROP, "adlfarerovcja;39 d"));
    }

    private EncryptUtil() {
        this.init();
    }

    public static void main(String[] args) {
        if (args[0] != null && args[0].length() > 0) {
            String encryptedValue = EncryptUtil.getInstance().encrypt(args[0]);
            System.out.println("Encrypted value=" + encryptedValue);
        }
    }

    public static boolean isEnabled() {
        boolean result = false;
        if (Config.getInstance().getProperty(CRYPTO_PROP) != null && !Config.getInstance().getProperty(CRYPTO_PROP).equals("${crypto.prop}")) {
            result = true;
        }
        return result;
    }

    public String encrypt(String clearText) {
        return this.textEncryptor.encrypt(clearText);
    }

    public String decrypt(String encryptedText) {
        return this.textEncryptor.decrypt(encryptedText);
    }
}

