/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;

public class RenameAction
extends StudioAction {
    @Override
    public String getText() {
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        if (connections.length == 1 && connectionFolders.length == 0) {
            return Messages.getString("RenameAction.Connection");
        }
        if (connectionFolders.length == 1 && connections.length == 0) {
            return Messages.getString("RenameAction.ConnectionFolder");
        }
        return Messages.getString("RenameAction.Rename");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.edit.rename";
    }

    @Override
    public void run() {
        Connection[] connections = this.getSelectedConnections();
        ConnectionFolder[] connectionFolders = this.getSelectedConnectionFolders();
        if (connections.length == 1) {
            this.renameConnection(connections[0]);
        } else if (connectionFolders.length == 1) {
            this.renameConnectionFolder(connectionFolders[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedConnections().length + this.getSelectedConnectionFolders().length == 1;
    }

    private void renameConnection(Connection connection) {
        IInputValidator validator = newName -> {
            if (connection.getName().equals(newName)) {
                return null;
            }
            if (ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionByName(newName) == null) {
                return null;
            }
            return Messages.getString("RenameAction.ConnectionAlreadyExists");
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("RenameAction.RenameConnection"), Messages.getString("RenameAction.NewNameConnection"), connection.getName(), validator);
        dialog.open();
        String newName2 = dialog.getValue();
        if (newName2 != null) {
            connection.setName(newName2);
        }
    }

    private void renameConnectionFolder(ConnectionFolder connectionFolder) {
        IInputValidator validator = newName -> {
            if (connectionFolder.getName().equals(newName)) {
                return null;
            }
            if (ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolderByName(newName) == null) {
                return null;
            }
            return Messages.getString("RenameAction.ConnectionFolderAlreadyExists");
        };
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("RenameAction.RenameConnectionFolder"), Messages.getString("RenameAction.NewNameConnectionFolder"), connectionFolder.getName(), validator);
        dialog.open();
        String newName2 = dialog.getValue();
        if (newName2 != null) {
            connectionFolder.setName(newName2);
        }
    }
}

