/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportCsvRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportCsvFromWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportCsvToWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ExportCsvWizard
extends ExportBaseWizard {
    private ExportCsvFromWizardPage fromPage;
    private ExportCsvToWizardPage toPage;

    public ExportCsvWizard() {
        super(Messages.getString("ExportCsvWizard.CSVExport"));
    }

    public static String getId() {
        return BrowserUIConstants.WIZARD_EXPORT_CSV;
    }

    public void addPages() {
        this.fromPage = new ExportCsvFromWizardPage(ExportCsvFromWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.fromPage);
        this.toPage = new ExportCsvToWizardPage(ExportCsvToWizardPage.class.getName(), this);
        this.addPage((IWizardPage)this.toPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fromPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_csvexport_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.toPage.getControl(), String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_csvexport_wizard");
    }

    public boolean performFinish() {
        this.fromPage.saveDialogSettings();
        this.toPage.saveDialogSettings();
        boolean exportDn = this.fromPage.isExportDn();
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new ExportCsvRunnable(this.exportFilename, this.search.getBrowserConnection(), this.search.getSearchParameter(), exportDn)}).execute();
        return true;
    }
}

