/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.StringUtils;

public class Base64Compression {
    public static String compressBase64(String srcTxt) throws IOException {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(rstBao);){
            zos.write(srcTxt.getBytes(StandardCharsets.UTF_8));
        }
        byte[] bytes = rstBao.toByteArray();
        return StringUtils.encodeBase64String((byte[])bytes);
    }

    public static String decompressBase64(String zippedBase64Str) throws IOException {
        byte[] bytes = StringUtils.decodeBase64String((String)zippedBase64Str);
        try (GZIPInputStream zi = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            String string = IOUtils.toString((InputStream)zi, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

