/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.vertx.VertxHttpClientBuilder;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import org.apache.druid.k8s.overlord.common.DruidKubernetesHttpClientConfig;

public class DruidKubernetesHttpClientFactory
implements HttpClient.Factory {
    private final Vertx vertx;

    public DruidKubernetesHttpClientFactory(DruidKubernetesHttpClientConfig httpClientConfig) {
        this.vertx = DruidKubernetesHttpClientFactory.createVertxInstance(httpClientConfig);
    }

    public VertxHttpClientBuilder<DruidKubernetesHttpClientFactory> newBuilder() {
        return new VertxHttpClientBuilder((HttpClient.Factory)this, this.vertx);
    }

    private static Vertx createVertxInstance(DruidKubernetesHttpClientConfig httpClientConfig) {
        Vertx vertx;
        String originalDnsResolverProperty = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(false).setClassPathResolvingEnabled(false)).setWorkerPoolSize(httpClientConfig.getWorkerPoolSize()).setEventLoopPoolSize(httpClientConfig.getEventLoopPoolSize()).setInternalBlockingPoolSize(httpClientConfig.getInternalBlockingPoolSize()).setUseDaemonThread(Boolean.valueOf(true)));
        }
        finally {
            if (originalDnsResolverProperty == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalDnsResolverProperty);
            }
        }
        return vertx;
    }
}

