/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.inject.Inject;
import java.net.URL;
import org.apache.druid.indexing.overlord.DruidOverlord;
import org.apache.druid.indexing.overlord.http.OverlordRedirectInfo;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.CoordinatorRedirectInfo;
import org.apache.druid.server.http.RedirectInfo;

public class CoordinatorOverlordRedirectInfo
implements RedirectInfo {
    private final OverlordRedirectInfo overlordRedirectInfo;
    private final CoordinatorRedirectInfo coordinatorRedirectInfo;

    @Inject
    public CoordinatorOverlordRedirectInfo(DruidOverlord druidOverlord, DruidCoordinator druidCoordinator) {
        this.overlordRedirectInfo = new OverlordRedirectInfo(druidOverlord);
        this.coordinatorRedirectInfo = new CoordinatorRedirectInfo(druidCoordinator);
    }

    public boolean doLocal(String requestURI) {
        return this.isOverlordRequest(requestURI) ? this.overlordRedirectInfo.doLocal(requestURI) : this.coordinatorRedirectInfo.doLocal(requestURI);
    }

    public URL getRedirectURL(String queryString, String requestURI) {
        return this.isOverlordRequest(requestURI) ? this.overlordRedirectInfo.getRedirectURL(queryString, requestURI) : this.coordinatorRedirectInfo.getRedirectURL(queryString, requestURI);
    }

    private boolean isOverlordRequest(String requestURI) {
        return requestURI.startsWith("/druid/indexer");
    }
}

