/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;

public class PlannerLookupCache {
    @Nullable
    private final LookupExtractorFactoryContainerProvider lookupProvider;
    private final Map<String, LookupExtractor> map;

    PlannerLookupCache(@Nullable LookupExtractorFactoryContainerProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.map = new HashMap<String, LookupExtractor>();
    }

    @Nullable
    LookupExtractor getLookup(String lookupName) {
        if (this.lookupProvider == null) {
            return null;
        }
        return this.map.computeIfAbsent(lookupName, name -> {
            Optional maybeContainer = this.lookupProvider.get(name);
            return maybeContainer.map(container -> (LookupExtractor)container.getLookupExtractorFactory().get()).orElse(null);
        });
    }
}

