/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationConstants;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.Text;

public class SessionTokenIdentifier
extends AbstractS3ATokenIdentifier {
    private MarshalledCredentials marshalledCredentials = new MarshalledCredentials();

    public SessionTokenIdentifier() {
        super(DelegationConstants.SESSION_TOKEN_KIND);
    }

    protected SessionTokenIdentifier(Text kind) {
        super(kind);
    }

    public SessionTokenIdentifier(Text kind, Text owner, Text renewer, URI uri, MarshalledCredentials marshalledCredentials, EncryptionSecrets encryptionSecrets, String origin) {
        super(kind, uri, owner, renewer, origin, encryptionSecrets);
        this.marshalledCredentials = marshalledCredentials;
    }

    public SessionTokenIdentifier(Text kind, Text owner, Text renewer, Text realUser, URI uri) {
        super(kind, owner, renewer, realUser, uri);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.marshalledCredentials.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.marshalledCredentials.readFields(in);
    }

    @Override
    public long getExpiryTime() {
        return this.marshalledCredentials.getExpiration();
    }

    public MarshalledCredentials getMarshalledCredentials() {
        return this.marshalledCredentials;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.marshalledCredentials.toString();
    }
}

