/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class FrameChannelMixer
implements FrameProcessor<Long> {
    private final List<ReadableFrameChannel> inputChannels;
    private final WritableFrameChannel outputChannel;
    private final IntSet awaitSet;
    private long rowsRead = 0L;

    public FrameChannelMixer(List<ReadableFrameChannel> inputChannels, WritableFrameChannel outputChannel) {
        this.inputChannels = inputChannels;
        this.outputChannel = outputChannel;
        this.awaitSet = FrameProcessors.rangeSet(inputChannels.size());
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        int channelNumber;
        ReadableFrameChannel channel;
        IntAVLTreeSet readySet = new IntAVLTreeSet((IntCollection)readableInputs);
        IntIterator intIterator = readableInputs.iterator();
        while (intIterator.hasNext()) {
            int channelNumber2 = (Integer)intIterator.next();
            ReadableFrameChannel channel2 = this.inputChannels.get(channelNumber2);
            if (!channel2.isFinished()) continue;
            this.awaitSet.remove(channelNumber2);
            readySet.remove(channelNumber2);
        }
        if (!readySet.isEmpty() && !(channel = this.inputChannels.get(channelNumber = FrameProcessors.selectRandom((IntSet)readySet))).isFinished()) {
            Frame frame = channel.read();
            this.outputChannel.write(frame);
            this.rowsRead += (long)frame.numRows();
        }
        if (this.awaitSet.isEmpty()) {
            return ReturnOrAwait.returnObject(this.rowsRead);
        }
        return ReturnOrAwait.awaitAny(this.awaitSet);
    }

    @Override
    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), new Closeable[0]);
    }
}

