/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.IdMapping;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

final class ForwardingFilteredDimensionSelector
extends AbstractDimensionSelector
implements IdLookup {
    private final DimensionSelector selector;
    private final IdLookup baseIdLookup;
    private final IdMapping idMapping;
    private final ArrayBasedIndexedInts row = new ArrayBasedIndexedInts();

    public ForwardingFilteredDimensionSelector(DimensionSelector selector, IdMapping idMapping) {
        this.selector = (DimensionSelector)Preconditions.checkNotNull((Object)selector);
        if (!selector.nameLookupPossibleInAdvance()) {
            throw new IAE("selector.nameLookupPossibleInAdvance() should return true", new Object[0]);
        }
        this.baseIdLookup = selector.idLookup();
        this.idMapping = (IdMapping)Preconditions.checkNotNull((Object)idMapping);
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts baseRow = this.selector.getRow();
        int baseRowSize = baseRow.size();
        this.row.ensureSize(baseRowSize);
        int resultSize = 0;
        for (int i = 0; i < baseRowSize; ++i) {
            int forwardedValue = this.idMapping.getForwardedId(baseRow.get(i));
            if (forwardedValue < 0) continue;
            this.row.setValue(resultSize, forwardedValue);
            ++resultSize;
        }
        this.row.setSize(resultSize);
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        IdLookup idLookup = this.idLookup();
        if (idLookup != null) {
            final int valueId = idLookup.lookupId(value);
            final int nullId = this.baseIdLookup.lookupId(null);
            return new ValueMatcher(){

                @Override
                public boolean matches(boolean includeUnknown) {
                    IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                    int baseRowSize = baseRow.size();
                    boolean nullRow = true;
                    for (int i = 0; i < baseRowSize; ++i) {
                        int baseId = baseRow.get(i);
                        if (includeUnknown && nullId == baseId) {
                            return true;
                        }
                        int forwardedId = ForwardingFilteredDimensionSelector.this.idMapping.getForwardedId(baseId);
                        if (forwardedId < 0) continue;
                        if (forwardedId == valueId) {
                            return true;
                        }
                        nullRow = false;
                    }
                    return nullRow && (includeUnknown || value == null);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
                }
            };
        }
        return this.makeValueMatcher(StringPredicateDruidPredicateFactory.equalTo(value));
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
        final Supplier valueIds = Suppliers.memoize(() -> DimensionSelectorUtils.makePredicateMatchingSet(this, predicate, false));
        final Supplier valueIdsWithUnknown = Suppliers.memoize(() -> DimensionSelectorUtils.makePredicateMatchingSet(this, predicate, true));
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    int baseId = baseRow.get(i);
                    int forwardedValue = ForwardingFilteredDimensionSelector.this.idMapping.getForwardedId(baseId);
                    if (forwardedValue < 0) continue;
                    if (includeUnknown ? ((BitSet)valueIdsWithUnknown.get()).get(forwardedValue) : ((BitSet)valueIds.get()).get(forwardedValue)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && predicate.apply(null).matches(includeUnknown);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return this.idMapping.getValueCardinality();
    }

    @Override
    public String lookupName(int id) {
        return this.selector.lookupName(this.idMapping.getReverseId(id));
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.baseIdLookup != null ? this : null;
    }

    @Override
    public int lookupId(String name) {
        return this.idMapping.getForwardedId(this.baseIdLookup.lookupId(name));
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

