/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.timeline.SegmentId;

public class SegmentSchemaMapping {
    private final Map<String, SegmentMetadata> segmentIdToMetadataMap;
    private final Map<String, SchemaPayload> schemaFingerprintToPayloadMap;
    private final int schemaVersion;

    @JsonCreator
    public SegmentSchemaMapping(@JsonProperty(value="segmentIdToMetadataMap") Map<String, SegmentMetadata> segmentIdToMetadataMap, @JsonProperty(value="schemaFingerprintToPayloadMap") Map<String, SchemaPayload> schemaFingerprintToPayloadMap, @JsonProperty(value="schemaVersion") int schemaVersion) {
        this.segmentIdToMetadataMap = segmentIdToMetadataMap;
        this.schemaFingerprintToPayloadMap = schemaFingerprintToPayloadMap;
        this.schemaVersion = schemaVersion;
    }

    public SegmentSchemaMapping(int schemaVersion) {
        this.segmentIdToMetadataMap = new HashMap<String, SegmentMetadata>();
        this.schemaFingerprintToPayloadMap = new HashMap<String, SchemaPayload>();
        this.schemaVersion = schemaVersion;
    }

    @JsonProperty
    public Map<String, SegmentMetadata> getSegmentIdToMetadataMap() {
        return this.segmentIdToMetadataMap;
    }

    @JsonProperty
    public Map<String, SchemaPayload> getSchemaFingerprintToPayloadMap() {
        return this.schemaFingerprintToPayloadMap;
    }

    @JsonProperty
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean isNonEmpty() {
        return this.segmentIdToMetadataMap.size() > 0;
    }

    public void addSchema(SegmentId segmentId, SchemaPayloadPlus schemaPayloadPlus, String fingerprint) {
        this.segmentIdToMetadataMap.put(segmentId.toString(), new SegmentMetadata(schemaPayloadPlus.getNumRows(), fingerprint));
        this.schemaFingerprintToPayloadMap.put(fingerprint, schemaPayloadPlus.getSchemaPayload());
    }

    public void merge(SegmentSchemaMapping other) {
        this.segmentIdToMetadataMap.putAll(other.getSegmentIdToMetadataMap());
        this.schemaFingerprintToPayloadMap.putAll(other.getSchemaFingerprintToPayloadMap());
    }

    public int getSchemaCount() {
        return this.schemaFingerprintToPayloadMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentSchemaMapping that = (SegmentSchemaMapping)o;
        return this.schemaVersion == that.schemaVersion && Objects.equals(this.segmentIdToMetadataMap, that.segmentIdToMetadataMap) && Objects.equals(this.schemaFingerprintToPayloadMap, that.schemaFingerprintToPayloadMap);
    }

    public int hashCode() {
        return Objects.hash(this.segmentIdToMetadataMap, this.schemaFingerprintToPayloadMap, this.schemaVersion);
    }

    public String toString() {
        return "SegmentSchemaMapping{segmentIdToMetadataMap=" + String.valueOf(this.segmentIdToMetadataMap) + ", schemaFingerprintToPayloadMap=" + String.valueOf(this.schemaFingerprintToPayloadMap) + ", version='" + this.schemaVersion + "'}";
    }
}

