/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter.rewrite;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.Equiconditions;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.RhsRewriteCandidate;

public class RhsRewriteCandidates {
    private final Set<RhsRewriteCandidate> rhsRewriteCandidates;

    private RhsRewriteCandidates(Set<RhsRewriteCandidate> rhsRewriteCandidates) {
        this.rhsRewriteCandidates = rhsRewriteCandidates;
    }

    public Set<RhsRewriteCandidate> getRhsRewriteCandidates() {
        return this.rhsRewriteCandidates;
    }

    public static RhsRewriteCandidates getRhsRewriteCandidates(List<Filter> normalizedJoinTableClauses, Equiconditions equiconditions, JoinableClauses joinableClauses) {
        LinkedHashSet<RhsRewriteCandidate> rhsRewriteCandidates = new LinkedHashSet<RhsRewriteCandidate>();
        for (Filter orClause : normalizedJoinTableClauses) {
            if (Filters.filterMatchesNull(orClause)) continue;
            if (orClause instanceof OrFilter) {
                for (Filter subFilter : ((OrFilter)orClause).getFilters()) {
                    Optional<RhsRewriteCandidate> rhsRewriteCandidate = RhsRewriteCandidates.determineRhsRewriteCandidatesForSingleFilter(subFilter, equiconditions, joinableClauses);
                    rhsRewriteCandidate.ifPresent(rhsRewriteCandidates::add);
                }
                continue;
            }
            Optional<RhsRewriteCandidate> rhsRewriteCandidate = RhsRewriteCandidates.determineRhsRewriteCandidatesForSingleFilter(orClause, equiconditions, joinableClauses);
            rhsRewriteCandidate.ifPresent(rhsRewriteCandidates::add);
        }
        return new RhsRewriteCandidates(rhsRewriteCandidates);
    }

    private static Optional<RhsRewriteCandidate> determineRhsRewriteCandidatesForSingleFilter(Filter orClause, Equiconditions equiconditions, JoinableClauses joinableClauses) {
        if (equiconditions.doesFilterSupportDirectJoinFilterRewrite(orClause)) {
            String reqColumn = orClause.getRequiredColumns().iterator().next();
            JoinableClause joinableClause = joinableClauses.getColumnFromJoinIfExists(reqColumn);
            if (joinableClause != null) {
                return Optional.of(new RhsRewriteCandidate(joinableClause, reqColumn, null, true));
            }
        } else if (orClause instanceof SelectorFilter) {
            String reqColumn = ((SelectorFilter)orClause).getDimension();
            String reqValue = ((SelectorFilter)orClause).getValue();
            JoinableClause joinableClause = joinableClauses.getColumnFromJoinIfExists(reqColumn);
            if (joinableClause != null) {
                return Optional.of(new RhsRewriteCandidate(joinableClause, reqColumn, reqValue, false));
            }
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RhsRewriteCandidates that = (RhsRewriteCandidates)o;
        return Objects.equals(this.rhsRewriteCandidates, that.rhsRewriteCandidates);
    }

    public int hashCode() {
        return Objects.hash(this.rhsRewriteCandidates);
    }
}

