/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.timeline.SegmentId;

public class FireHydrant {
    private final int count;
    private final AtomicReference<ReferenceCountedSegmentProvider> segmentReferenceProvider;
    @Nullable
    private volatile IncrementalIndex index;

    public FireHydrant(IncrementalIndex index, int count, SegmentId segmentId) {
        this.index = index;
        this.segmentReferenceProvider = new AtomicReference<ReferenceCountedSegmentProvider>(ReferenceCountedSegmentProvider.wrapRootGenerationSegment((Segment)new IncrementalIndexSegment(index, segmentId)));
        this.count = count;
    }

    public FireHydrant(Segment segment, int count) {
        this.index = null;
        this.segmentReferenceProvider = new AtomicReference<ReferenceCountedSegmentProvider>(ReferenceCountedSegmentProvider.wrapRootGenerationSegment((Segment)segment));
        this.count = count;
    }

    @Nullable
    public IncrementalIndex getIndex() {
        return this.index;
    }

    public SegmentId getSegmentId() {
        return this.segmentReferenceProvider.get().getBaseSegment().getId();
    }

    public int getSegmentNumDimensionColumns() {
        if (this.hasSwapped()) {
            QueryableIndex queryableIndex;
            Segment segment = this.segmentReferenceProvider.get().getBaseSegment();
            if (segment != null && (queryableIndex = (QueryableIndex)segment.as(QueryableIndex.class)) != null) {
                return queryableIndex.getAvailableDimensions().size();
            }
        } else {
            return this.index.getDimensions().size();
        }
        return 0;
    }

    public int getSegmentNumMetricColumns() {
        Segment segment = this.segmentReferenceProvider.get().getBaseSegment();
        if (segment != null) {
            PhysicalSegmentInspector segmentInspector = (PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class);
            Metadata metadata = segmentInspector == null ? null : segmentInspector.getMetadata();
            return metadata != null && metadata.getAggregators() != null ? metadata.getAggregators().length : 0;
        }
        return 0;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    public void swapSegment(@Nullable Segment newSegment) {
        ReferenceCountedSegmentProvider newReferenceCountingSegment;
        ReferenceCountedSegmentProvider currentSegment;
        do {
            if ((currentSegment = this.segmentReferenceProvider.get()) == null && newSegment == null) {
                return;
            }
            if (currentSegment != null && newSegment != null && !newSegment.getId().equals((Object)currentSegment.getBaseSegment().getId())) {
                throw new ISE("Cannot swap identifier[%s] -> [%s]", new Object[]{currentSegment.getBaseSegment().getId(), newSegment.getId()});
            }
            if (currentSegment == null || currentSegment.getBaseSegment() != newSegment) continue;
            throw new ISE("Cannot swap to the same segment", new Object[0]);
        } while (!this.segmentReferenceProvider.compareAndSet(currentSegment, newReferenceCountingSegment = newSegment != null ? ReferenceCountedSegmentProvider.wrapRootGenerationSegment((Segment)newSegment) : null));
        if (currentSegment != null) {
            currentSegment.close();
        }
        this.index = null;
    }

    public Segment acquireSegment() {
        ReferenceCountedSegmentProvider segment = this.segmentReferenceProvider.get();
        Optional maybeSegment;
        while (!(maybeSegment = segment.acquireReference()).isPresent()) {
            ReferenceCountedSegmentProvider newSegment = this.segmentReferenceProvider.get();
            if (segment == newSegment) {
                throw new ISE("segment.close() is called somewhere outside FireHydrant.swapSegment()", new Object[0]);
            }
            if (newSegment == null) {
                throw new ISE("FireHydrant was 'closed' by swapping segment to null while acquiring a segment", new Object[0]);
            }
            segment = newSegment;
        }
        return (Segment)maybeSegment.get();
    }

    public Optional<Segment> getSegmentForQuery(SegmentMapFunction segmentMapFn) {
        ReferenceCountedSegmentProvider sinkSegment = this.segmentReferenceProvider.get();
        if (sinkSegment == null) {
            return Optional.empty();
        }
        Optional segment = (Optional)segmentMapFn.apply((Object)sinkSegment);
        while (!segment.isPresent()) {
            ReferenceCountedSegmentProvider newSinkSegment = this.segmentReferenceProvider.get();
            if (newSinkSegment == null) {
                return Optional.empty();
            }
            if (sinkSegment == newSinkSegment) {
                if (newSinkSegment.isClosed()) {
                    throw new ISE("segment.close() is called somewhere outside FireHydrant.swapSegment()", new Object[0]);
                }
                return Optional.empty();
            }
            segment = (Optional)segmentMapFn.apply((Object)newSinkSegment);
        }
        return segment;
    }

    @VisibleForTesting
    public ReferenceCountedSegmentProvider getHydrantSegment() {
        return this.segmentReferenceProvider.get();
    }

    public String toString() {
        return "FireHydrant{queryable=" + String.valueOf(this.segmentReferenceProvider.get() == null ? "null" : this.segmentReferenceProvider.get().getBaseSegment().getId()) + ", count=" + this.count + "}";
    }
}

