/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.DatasourceProjectionMetadata;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Period;

public class CatalogDataSourceCompactionConfig
implements DataSourceCompactionConfig {
    private final String dataSource;
    @Nullable
    private final CompactionEngine engine;
    private final Period skipOffsetFromLatest;
    private final int taskPriority;
    @Nullable
    private final Map<String, Object> taskContext;
    private final long inputSegmentSizeBytes;
    private final MetadataCatalog catalog;
    private final TableId tableId;

    @JsonCreator
    public CatalogDataSourceCompactionConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="engine") @Nullable CompactionEngine engine, @JsonProperty(value="skipOffsetFromLatest") @Nullable Period skipOffsetFromLatest, @JsonProperty(value="taskPriority") @Nullable Integer taskPriority, @JsonProperty(value="taskContext") @Nullable Map<String, Object> taskContext, @JsonProperty(value="inputSegmentSizeBytes") @Nullable Long inputSegmentSizeBytes, @JacksonInject MetadataCatalog metadataCatalog) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.engine = engine;
        this.skipOffsetFromLatest = skipOffsetFromLatest == null ? DEFAULT_SKIP_OFFSET_FROM_LATEST : skipOffsetFromLatest;
        this.inputSegmentSizeBytes = inputSegmentSizeBytes == null ? 100000000000000L : inputSegmentSizeBytes;
        this.taskPriority = taskPriority == null ? 25 : taskPriority;
        this.taskContext = taskContext;
        this.catalog = metadataCatalog;
        this.tableId = TableId.datasource(dataSource);
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    @Nullable
    public CompactionEngine getEngine() {
        return this.engine;
    }

    @Override
    @JsonProperty
    public Period getSkipOffsetFromLatest() {
        return this.skipOffsetFromLatest;
    }

    @Override
    @JsonProperty
    public int getTaskPriority() {
        return this.taskPriority;
    }

    @Override
    @JsonProperty
    @Nullable
    public Map<String, Object> getTaskContext() {
        return this.taskContext;
    }

    @Override
    @JsonProperty
    public long getInputSegmentSizeBytes() {
        return this.inputSegmentSizeBytes;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public UserCompactionTaskQueryTuningConfig getTuningConfig() {
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public UserCompactionTaskIOConfig getIoConfig() {
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Granularity getSegmentGranularity() {
        ResolvedTable table = this.catalog.resolveTable(this.tableId);
        if (table == null) {
            return null;
        }
        return CatalogUtils.asDruidGranularity((String)table.decodeProperty("segmentGranularity"));
    }

    @Override
    @JsonIgnore
    @Nullable
    public UserCompactionTaskGranularityConfig getGranularitySpec() {
        return new UserCompactionTaskGranularityConfig(this.getSegmentGranularity(), null, null);
    }

    @Override
    @JsonIgnore
    @Nullable
    public List<AggregateProjectionSpec> getProjections() {
        ResolvedTable table = this.catalog.resolveTable(this.tableId);
        if (table == null) {
            return null;
        }
        List projections = (List)table.decodeProperty("projections");
        if (projections == null) {
            return null;
        }
        return projections.stream().map(DatasourceProjectionMetadata::getSpec).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    @Nullable
    public CompactionTransformSpec getTransformSpec() {
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public UserCompactionTaskDimensionsConfig getDimensionsSpec() {
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogDataSourceCompactionConfig that = (CatalogDataSourceCompactionConfig)o;
        return this.taskPriority == that.taskPriority && this.inputSegmentSizeBytes == that.inputSegmentSizeBytes && Objects.equals(this.dataSource, that.dataSource) && this.engine == that.engine && Objects.equals(this.skipOffsetFromLatest, that.skipOffsetFromLatest) && Objects.equals(this.taskContext, that.taskContext);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.engine, this.skipOffsetFromLatest, this.taskPriority, this.taskContext, this.inputSegmentSizeBytes);
    }
}

