/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.FixedLengthRecordReader;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FixedLengthInputFormat
extends FileInputFormat<LongWritable, BytesWritable>
implements JobConfigurable {
    private CompressionCodecFactory compressionCodecs = null;
    public static final String FIXED_RECORD_LENGTH = "fixedlengthinputformat.record.length";

    public static void setRecordLength(Configuration conf, int recordLength) {
        conf.setInt(FIXED_RECORD_LENGTH, recordLength);
    }

    public static int getRecordLength(Configuration conf) {
        return conf.getInt(FIXED_RECORD_LENGTH, 0);
    }

    @Override
    public void configure(JobConf conf) {
        this.compressionCodecs = new CompressionCodecFactory(conf);
    }

    @Override
    public RecordReader<LongWritable, BytesWritable> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        int recordLength = FixedLengthInputFormat.getRecordLength(job);
        if (recordLength <= 0) {
            throw new IOException("Fixed record length " + recordLength + " is invalid.  It should be set to a value greater than zero");
        }
        return new FixedLengthRecordReader(job, (FileSplit)genericSplit, recordLength);
    }

    @Override
    protected boolean isSplitable(FileSystem fs, Path file) {
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        return null == codec;
    }
}

