/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Schema
implements Comparable<Schema> {
    private String subject;
    private Integer version;
    private Integer id;
    private String schemaType;
    private List<SchemaReference> references;
    private String schema;

    @JsonCreator
    public Schema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="schema") String schema) {
        this.subject = subject;
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.schema = schema;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema1 = (Schema)o;
        return Objects.equals(this.subject, schema1.subject) && Objects.equals(this.version, schema1.version) && Objects.equals(this.id, schema1.id) && Objects.equals(this.schemaType, schema1.schemaType) && Objects.equals(this.references, schema1.references) && Objects.equals(this.schema, schema1.schema);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.id, this.schemaType, this.references, this.schema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.subject + ",");
        sb.append("version=" + this.version + ",");
        sb.append("id=" + this.id + ",");
        sb.append("schemaType=" + this.schemaType + ",");
        sb.append("references=" + this.references + ",");
        sb.append("schema=" + this.schema + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(Schema that) {
        int result = this.subject.compareTo(that.subject);
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }
}

