/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package judger

import (
	"regexp"
	"strings"
)

import (
	"dubbo.apache.org/dubbo-go/v3/config"
)

// nolint
type StringMatchJudger struct {
	config.StringMatch
}

// nolint
func (j *StringMatchJudger) Judge(input string) bool {
	if j.Exact != "" {
		return input == j.Exact
	}
	if j.Prefix != "" {
		return strings.HasPrefix(input, j.Prefix)
	}
	if j.Regex != "" {
		ok, err := regexp.MatchString(j.Regex, input)
		return ok && err == nil
	}
	if j.NoEmpty != "" {
		return input != ""
	}
	if j.Empty != "" {
		return input == ""
	}
	return true
}

// nolint
func NewStringMatchJudger(matchConf *config.StringMatch) *StringMatchJudger {
	return &StringMatchJudger{
		StringMatch: *matchConf,
	}
}
