/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.AsyncIterator;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ContinuationTokenAsyncIterator<Token, T>
implements AsyncIterator<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContinuationTokenAsyncIterator.class);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Queue<T> queue;
    @GuardedBy(value="lock")
    private Token token;
    private final Function<Token, CompletableFuture<Map.Entry<Token, Collection<T>>>> function;
    private CompletableFuture<Void> outstanding;
    private final AtomicBoolean canContinue;
    @GuardedBy(value="lock")
    private boolean isOutstanding;

    public ContinuationTokenAsyncIterator(@NonNull Function<Token, CompletableFuture<Map.Entry<Token, Collection<T>>>> function, Token tokenIdentity) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
        this.token = tokenIdentity;
        this.queue = new LinkedBlockingQueue<T>();
        this.outstanding = CompletableFuture.completedFuture(null);
        this.canContinue = new AtomicBoolean(true);
        this.isOutstanding = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<T> getNext() {
        Token continuationToken;
        boolean toCall = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.queue.isEmpty()) {
                return CompletableFuture.completedFuture(this.queue.poll());
            }
            continuationToken = this.token;
            if (this.outstanding.isDone() && !this.isOutstanding) {
                toCall = true;
                this.isOutstanding = true;
            }
        }
        if (toCall) {
            this.outstanding = this.function.apply(continuationToken).thenAccept(resultPair -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.token != null && this.token.equals(continuationToken)) {
                        log.debug("Received the following collection after calling the function: {} with continuation token: {}", resultPair.getValue(), resultPair.getKey());
                        this.canContinue.set(resultPair.getValue() != null && !((Collection)resultPair.getValue()).isEmpty());
                        this.queue.addAll((Collection)resultPair.getValue());
                        this.token = resultPair.getKey();
                        this.isOutstanding = false;
                    }
                }
            });
        }
        return this.outstanding.thenCompose((T v) -> {
            if (this.canContinue.get()) {
                return this.getNext();
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isInternalQueueEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Token getToken() {
        Object object = this.lock;
        synchronized (object) {
            return this.token;
        }
    }
}

