/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.Revisioned;
import io.pravega.client.state.RevisionedStreamClient;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.SynchronizerConfig;
import io.pravega.client.state.Update;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.impl.ClientFactoryImpl;

public interface SynchronizerClientFactory
extends AutoCloseable {
    public static SynchronizerClientFactory withScope(String scope, ClientConfig config) {
        ClientConfig updatedConfig = config.toBuilder().maxConnectionsPerSegmentStore(1).enableTlsToSegmentStore(config.isEnableTlsToSegmentStore()).enableTlsToController(config.isEnableTlsToController()).build();
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(updatedConfig, 1);
        return new ClientFactoryImpl(scope, new ControllerImpl(ControllerImplConfig.builder().clientConfig(updatedConfig).build(), connectionFactory.getInternalExecutor()), updatedConfig, connectionFactory);
    }

    public <T> RevisionedStreamClient<T> createRevisionedStreamClient(String var1, Serializer<T> var2, SynchronizerConfig var3);

    public <StateT extends Revisioned, UpdateT extends Update<StateT>, InitT extends InitialUpdate<StateT>> StateSynchronizer<StateT> createStateSynchronizer(String var1, Serializer<UpdateT> var2, Serializer<InitT> var3, SynchronizerConfig var4);

    @Override
    public void close();
}

