/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.segment.impl.SegmentOutputStreamImpl;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.common.util.Retry;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class SegmentOutputStreamFactoryImpl
implements SegmentOutputStreamFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentOutputStreamFactoryImpl.class);
    private final Controller controller;
    private final ConnectionPool cp;
    private final Consumer<Segment> nopSegmentSealedCallback = s -> log.error("Transaction segment: {} cannot be sealed", s);

    @Override
    public SegmentOutputStream createOutputStreamForTransaction(Segment segment, UUID txId, EventWriterConfig config, DelegationTokenProvider tokenProvider) {
        return new SegmentOutputStreamImpl(NameUtils.getTransactionNameFromId((String)segment.getScopedName(), (UUID)txId), config.isEnableConnectionPooling(), this.controller, this.cp, UUID.randomUUID(), this.nopSegmentSealedCallback, this.getRetryFromConfig(config), tokenProvider);
    }

    @Override
    public SegmentOutputStream createOutputStreamForSegment(Segment segment, Consumer<Segment> segmentSealedCallback, EventWriterConfig config, DelegationTokenProvider tokenProvider) {
        SegmentOutputStreamImpl result = new SegmentOutputStreamImpl(segment.getScopedName(), config.isEnableConnectionPooling(), this.controller, this.cp, UUID.randomUUID(), segmentSealedCallback, this.getRetryFromConfig(config), tokenProvider);
        try {
            result.getConnection();
        }
        catch (NoSuchSegmentException | SegmentSealedException | RetriesExhaustedException e) {
            log.warn("Initial connection attempt failure. Suppressing.", e);
        }
        return result;
    }

    @Override
    public SegmentOutputStream createOutputStreamForSegment(Segment segment, EventWriterConfig config, DelegationTokenProvider tokenProvider) {
        return new SegmentOutputStreamImpl(segment.getScopedName(), config.isEnableConnectionPooling(), this.controller, this.cp, UUID.randomUUID(), Callbacks::doNothing, this.getRetryFromConfig(config), tokenProvider);
    }

    private Retry.RetryWithBackoff getRetryFromConfig(EventWriterConfig config) {
        return Retry.withExpBackoff((long)config.getInitialBackoffMillis(), (int)config.getBackoffMultiple(), (int)config.getRetryAttempts(), (long)config.getMaxBackoffMillis());
    }

    @ConstructorProperties(value={"controller", "cp"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentOutputStreamFactoryImpl(Controller controller, ConnectionPool cp) {
        this.controller = controller;
        this.cp = cp;
    }
}

