/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.broker.task;

import io.cloudevents.CloudEvent;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.storage.standalone.broker.StandaloneBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscribe {
    private static final Logger log = LoggerFactory.getLogger(Subscribe.class);
    private final String topicName;
    private final StandaloneBroker standaloneBroker;
    private final EventListener listener;
    private volatile boolean isRunning;
    private AtomicInteger offset;

    public Subscribe(String topicName, StandaloneBroker standaloneBroker, EventListener listener) {
        this.topicName = topicName;
        this.standaloneBroker = standaloneBroker;
        this.listener = listener;
        this.isRunning = true;
    }

    public void subscribe() {
        try {
            CloudEvent message;
            log.debug("execute subscribe task, topic: {}, offset: {}", (Object)this.topicName, (Object)this.offset);
            if (this.offset == null && (message = this.standaloneBroker.getMessage(this.topicName)) != null) {
                Object tmpOffset = message.getExtension("offset");
                this.offset = tmpOffset instanceof Integer ? new AtomicInteger(Integer.parseInt(tmpOffset.toString())) : new AtomicInteger(0);
            }
            if (this.offset != null && (message = this.standaloneBroker.getMessage(this.topicName, this.offset.get())) != null) {
                EventMeshAsyncConsumeContext consumeContext = new EventMeshAsyncConsumeContext(){

                    public void commit(EventMeshAction action) {
                        switch (action) {
                            case CommitMessage: {
                                log.info("message commit, topic: {}, current offset:{}", (Object)Subscribe.this.topicName, (Object)Subscribe.this.offset.get());
                                break;
                            }
                            case ManualAck: {
                                Subscribe.this.offset.incrementAndGet();
                                log.info("message ack, topic: {}, current offset:{}", (Object)Subscribe.this.topicName, (Object)Subscribe.this.offset.get());
                                break;
                            }
                        }
                    }
                };
                this.listener.consume(message, (AsyncConsumeContext)consumeContext);
            }
        }
        catch (Exception ex) {
            log.error("consumer error, topic: {}, offset: {}", new Object[]{this.topicName, this.offset == null ? null : Integer.valueOf(this.offset.get()), ex});
        }
    }

    public void shutdown() {
        this.isRunning = false;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public AtomicInteger getOffset() {
        return this.offset;
    }
}

