/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.exception.ProtocolNotSupportException;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.enums.EventMeshProtocolType;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.ProtoSupport;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshCloudEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(EventMeshCloudEventBuilder.class);
    private static final String CLOUD_EVENT_TYPE = "org.apache.eventmesh";
    private static final EventFormat eventProtoFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+protobuf");

    public static Map<String, CloudEvent.CloudEventAttributeValue> buildCommonCloudEventAttributes(EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType) {
        HashMap<String, CloudEvent.CloudEventAttributeValue> attributeValueMap = new HashMap<String, CloudEvent.CloudEventAttributeValue>(64);
        attributeValueMap.put("env", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getEnv()).build());
        attributeValueMap.put("idc", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getIdc()).build());
        attributeValueMap.put("ip", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(IPUtils.getLocalAddress()).build());
        attributeValueMap.put("pid", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(Long.toString(ThreadUtils.getPID())).build());
        attributeValueMap.put("sys", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getSys()).build());
        attributeValueMap.put("language", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getLanguage()).build());
        attributeValueMap.put("username", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getUserName()).build());
        attributeValueMap.put("passwd", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getPassword()).build());
        attributeValueMap.put("protocoltype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(protocolType.protocolTypeName()).build());
        attributeValueMap.put("protocolversion", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(SpecVersion.V1.toString()).build());
        return attributeValueMap;
    }

    public static CloudEvent buildEventSubscription(EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType, String url, List<SubscriptionItem> subscriptionItems) {
        if (CollectionUtils.isEmpty(subscriptionItems)) {
            return null;
        }
        HashSet<SubscriptionItem> subscriptionItemSet = new HashSet<SubscriptionItem>();
        subscriptionItemSet.addAll(subscriptionItems);
        Map<String, CloudEvent.CloudEventAttributeValue> attributeValueMap = EventMeshCloudEventBuilder.buildCommonCloudEventAttributes(clientConfig, protocolType);
        attributeValueMap.put("consumergroup", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getConsumerGroup()).build());
        attributeValueMap.put("datacontenttype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString("application/json").build());
        if (StringUtils.isNotBlank((CharSequence)url)) {
            attributeValueMap.put("url", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(url).build());
        }
        return CloudEvent.newBuilder().setId(RandomStringUtils.generateUUID()).setSource(URI.create("/").toString()).setSpecVersion(SpecVersion.V1.toString()).setType(CLOUD_EVENT_TYPE).setTextData(JsonUtils.toJSONString(subscriptionItemSet)).putAllAttributes(attributeValueMap).build();
    }

    public static <T> CloudEvent buildEventMeshCloudEvent(T message, EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType) {
        switch (protocolType) {
            case CLOUD_EVENTS: {
                if (!(message instanceof io.cloudevents.CloudEvent)) {
                    throw new ClassCastException(message.getClass().getName() + " can not cast io.cloudevents.CloudEvent");
                }
                return EventMeshCloudEventBuilder.switchCloudEvent2EventMeshCloudEvent((io.cloudevents.CloudEvent)message, clientConfig, protocolType);
            }
            case EVENT_MESH_MESSAGE: {
                if (!(message instanceof EventMeshMessage)) {
                    throw new ClassCastException(message.getClass().getName() + " can not cast" + EventMeshMessage.class.getName());
                }
                return EventMeshCloudEventBuilder.switchEventMeshMessage2EventMeshCloudEvent((EventMeshMessage)message, clientConfig, protocolType);
            }
            case OPEN_MESSAGE: {
                return null;
            }
        }
        throw new ProtocolNotSupportException("Protocol Type [" + protocolType + "] not support");
    }

    private static CloudEvent switchEventMeshMessage2EventMeshCloudEvent(EventMeshMessage message, EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType) {
        EventMeshMessage eventMeshMessage = message;
        String ttl = eventMeshMessage.getProp("ttl") == null ? "4000" : eventMeshMessage.getProp("ttl");
        Map<String, String> props = eventMeshMessage.getProp() == null ? new HashMap() : eventMeshMessage.getProp();
        String seqNum = eventMeshMessage.getBizSeqNo() == null ? RandomStringUtils.generateNum((int)30) : eventMeshMessage.getBizSeqNo();
        String uniqueId = eventMeshMessage.getUniqueId() == null ? RandomStringUtils.generateNum((int)30) : eventMeshMessage.getUniqueId();
        String dataContentType = props.computeIfAbsent("datacontenttype", key -> "text/plain");
        Map<String, CloudEvent.CloudEventAttributeValue> attributeValueMap = EventMeshCloudEventBuilder.buildCommonCloudEventAttributes(clientConfig, protocolType);
        attributeValueMap.put("ttl", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(ttl).build());
        attributeValueMap.put("seqnum", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(seqNum).build());
        attributeValueMap.put("uniqueid", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(uniqueId).build());
        attributeValueMap.put("producergroup", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(clientConfig.getProducerGroup()).build());
        if (null != eventMeshMessage.getTopic()) {
            attributeValueMap.put("subject", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(eventMeshMessage.getTopic()).build());
        }
        attributeValueMap.put("datacontenttype", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString("text/plain").build());
        props.entrySet().forEach(entry -> attributeValueMap.put((String)entry.getKey(), CloudEvent.CloudEventAttributeValue.newBuilder().setCeString((String)entry.getValue()).build()));
        CloudEvent.Builder builder = CloudEvent.newBuilder().setId(RandomStringUtils.generateUUID()).setSource(URI.create("/").toString()).setSpecVersion(SpecVersion.V1.toString()).setType(CLOUD_EVENT_TYPE).putAllAttributes(attributeValueMap);
        String content = eventMeshMessage.getContent();
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            if (ProtoSupport.isTextContent((String)dataContentType)) {
                builder.setTextData(content);
            } else if (ProtoSupport.isProtoContent((String)dataContentType)) {
                try {
                    Any dataAsAny = Any.parseFrom((byte[])content.getBytes(Constants.DEFAULT_CHARSET));
                    builder.setProtoData(dataAsAny);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalArgumentException("parse from byte[] to com.google.protobuf.Any error", e);
                }
            } else {
                ByteString byteString = ByteString.copyFrom((byte[])content.getBytes(Constants.DEFAULT_CHARSET));
                builder.setBinaryData(byteString);
            }
        }
        return builder.build();
    }

    private static CloudEvent switchCloudEvent2EventMeshCloudEvent(io.cloudevents.CloudEvent message, EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType) {
        io.cloudevents.CloudEvent cloudEvent = message;
        CloudEventBuilder cloudEventBuilder = CloudEventBuilder.from((io.cloudevents.CloudEvent)cloudEvent);
        if (null == cloudEvent.getExtension("env")) {
            cloudEventBuilder.withExtension("env", clientConfig.getEnv());
        }
        if (null == cloudEvent.getExtension("idc")) {
            cloudEventBuilder.withExtension("idc", clientConfig.getEnv());
        }
        if (null == cloudEvent.getExtension("ip")) {
            cloudEventBuilder.withExtension("ip", Objects.requireNonNull(IPUtils.getLocalAddress()));
        }
        if (null == cloudEvent.getExtension("pid")) {
            cloudEventBuilder.withExtension("pid", Long.toString(ThreadUtils.getPID()));
        }
        if (null == cloudEvent.getExtension("sys")) {
            cloudEventBuilder.withExtension("sys", clientConfig.getSys());
        }
        if (null == cloudEvent.getExtension("language")) {
            cloudEventBuilder.withExtension("language", "JAVA");
        }
        if (null == cloudEvent.getExtension("protocoltype")) {
            cloudEventBuilder.withExtension("protocoltype", protocolType.protocolTypeName());
        }
        if (null == cloudEvent.getExtension("protocoldesc")) {
            cloudEventBuilder.withExtension("protocoldesc", "grpc-cloud-event");
        }
        if (null == cloudEvent.getExtension("protocolversion")) {
            cloudEventBuilder.withExtension("protocolversion", cloudEvent.getSpecVersion().toString());
        }
        if (null == cloudEvent.getExtension("uniqueid")) {
            cloudEventBuilder.withExtension("uniqueid", RandomStringUtils.generateNum((int)30));
        }
        if (null == cloudEvent.getExtension("seqnum")) {
            cloudEventBuilder.withExtension("seqnum", RandomStringUtils.generateNum((int)30));
        }
        if (null == cloudEvent.getExtension("username")) {
            cloudEventBuilder.withExtension("username", clientConfig.getUserName());
        }
        if (null == cloudEvent.getExtension("passwd")) {
            cloudEventBuilder.withExtension("passwd", clientConfig.getPassword());
        }
        if (null == cloudEvent.getExtension("producergroup")) {
            cloudEventBuilder.withExtension("producergroup", clientConfig.getProducerGroup());
        }
        if (null == cloudEvent.getExtension("ttl")) {
            String ttl = "4000";
            cloudEventBuilder.withExtension("ttl", "4000");
        }
        try {
            return CloudEvent.parseFrom((byte[])eventProtoFormat.serialize(cloudEventBuilder.build()));
        }
        catch (InvalidProtocolBufferException exc) {
            log.error("Parse from CloudEvents CloudEvent bytes to EventMesh CloudEvent error", (Throwable)exc);
            return null;
        }
    }

    public static <T> CloudEventBatch buildEventMeshCloudEventBatch(List<T> messageList, EventMeshGrpcClientConfig clientConfig, EventMeshProtocolType protocolType) {
        if (CollectionUtils.isEmpty(messageList)) {
            return null;
        }
        List cloudEventList = messageList.stream().map(item -> EventMeshCloudEventBuilder.buildEventMeshCloudEvent(item, clientConfig, protocolType)).collect(Collectors.toList());
        return CloudEventBatch.newBuilder().addAllEvents(cloudEventList).build();
    }

    public static <T> T buildMessageFromEventMeshCloudEvent(CloudEvent cloudEvent, EventMeshProtocolType protocolType) {
        if (null == cloudEvent) {
            return null;
        }
        String seq = EventMeshCloudEventUtils.getSeqNum((CloudEvent)cloudEvent);
        String uniqueId = EventMeshCloudEventUtils.getUniqueId((CloudEvent)cloudEvent);
        String content = EventMeshCloudEventUtils.getDataContent((CloudEvent)cloudEvent);
        if (StringUtils.isEmpty((CharSequence)seq) && StringUtils.isEmpty((CharSequence)uniqueId)) {
            return (T)JsonUtils.parseTypeReferenceObject((String)content, (TypeReference)new TypeReference<Set<HashMap<String, String>>>(){});
        }
        if (null == protocolType) {
            return null;
        }
        switch (protocolType) {
            case CLOUD_EVENTS: {
                return (T)EventMeshCloudEventBuilder.switchEventMeshCloudEvent2CloudEvent(cloudEvent);
            }
            case EVENT_MESH_MESSAGE: {
                return (T)EventMeshCloudEventBuilder.switchEventMeshCloudEvent2EventMeshMessage(cloudEvent);
            }
        }
        return null;
    }

    private static io.cloudevents.CloudEvent switchEventMeshCloudEvent2CloudEvent(CloudEvent cloudEvent) {
        return eventProtoFormat.deserialize(Objects.requireNonNull(cloudEvent).toByteArray());
    }

    private static EventMeshMessage switchEventMeshCloudEvent2EventMeshMessage(CloudEvent cloudEvent) {
        HashMap prop = new HashMap();
        Objects.requireNonNull(cloudEvent).getAttributesMap().forEach((key, value) -> prop.put(key, value.getCeString()));
        return EventMeshMessage.builder().content(cloudEvent.getTextData()).topic(EventMeshCloudEventUtils.getSubject((CloudEvent)cloudEvent)).bizSeqNo(EventMeshCloudEventUtils.getSeqNum((CloudEvent)cloudEvent)).uniqueId(EventMeshCloudEventUtils.getUniqueId((CloudEvent)cloudEvent)).prop(prop).build();
    }
}

