/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.banner;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.banner.PinpointBanner;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class PinpointBannerImpl
extends PinpointBanner {
    private BootLogger logger;
    private Properties properties;

    public PinpointBannerImpl(List<String> keysToPrint, BootLogger logger) {
        this.pinpointBannerMode = PinpointBanner.Mode.CONSOLE;
        this.logger = Objects.requireNonNull(logger, "logger");
        this.keysToPrint = Objects.requireNonNull(keysToPrint, "keysToPrint");
    }

    public void setPinpointBannerProperty(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public void setPinpointBannerMode(PinpointBanner.Mode mode) {
        this.pinpointBannerMode = mode;
    }

    public void printBanner() {
        if (this.properties == null) {
            this.logger.warn("Property not ready for Pinpoint Banner");
            return;
        }
        switch (this.pinpointBannerMode) {
            case OFF: {
                return;
            }
            case LOG: {
                this.printBanner(this.logger);
                return;
            }
        }
        this.printBanner(System.out);
    }

    private void printBanner(PrintStream out) {
        for (String line : this.BANNER) {
            out.println(line);
        }
        out.println(this.format("Pinpoint Version", "2.4.1"));
        for (String key : this.keysToPrint) {
            String value = this.properties.getProperty(key);
            if (value == null) continue;
            out.println(this.format(key, value));
        }
        out.println();
    }

    private void printBanner(BootLogger logger) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(outputStream);
        this.printBanner(ps);
        logger.info(outputStream.toString());
    }
}

