/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.grpc.server.TransportMetadata;
import com.navercorp.pinpoint.grpc.server.TransportMetadataFactory;
import io.grpc.Attributes;
import io.grpc.ServerTransportFilter;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataServerTransportFilter
extends ServerTransportFilter {
    public static final Attributes.Key<Long> LOG_ID = Attributes.Key.create((String)"logId");
    public static final Attributes.Key<TransportMetadata> TRANSPORT_METADATA_KEY = Attributes.Key.create((String)"transportMetadata");
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final TransportMetadataFactory transportMetadataFactory;

    public MetadataServerTransportFilter(TransportMetadataFactory transportMetadataFactory) {
        this.transportMetadataFactory = Objects.requireNonNull(transportMetadataFactory, "transportMetadataFactory");
    }

    public Attributes transportReady(Attributes attributes) {
        TransportMetadata transportMetadata = this.transportMetadataFactory.build(attributes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("transportReady transportMetadata={}", (Object)transportMetadata);
        }
        Attributes.Builder builder = attributes.toBuilder();
        builder.set(TRANSPORT_METADATA_KEY, (Object)transportMetadata);
        return builder.build();
    }

    public void transportTerminated(Attributes transportAttrs) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("transportTerminated attributes={}", (Object)transportAttrs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetadataServerTransportFilter{");
        sb.append("transportMetadataFactory=").append(this.transportMetadataFactory);
        sb.append('}');
        return sb.toString();
    }
}

