/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandler;
import com.navercorp.pinpoint.rpc.common.SocketState;
import com.navercorp.pinpoint.rpc.common.SocketStateChangeResult;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PinpointClientHandlerState {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String objectName;
    private final DefaultPinpointClientHandler clientHandler;
    private final List<StateChangeEventListener> stateChangeEventListeners;
    private final SocketState state;

    public PinpointClientHandlerState(String objectName, DefaultPinpointClientHandler clientHandler, List<StateChangeEventListener> stateChangeEventListeners) {
        this.objectName = Objects.requireNonNull(objectName, "objectName");
        this.clientHandler = clientHandler;
        this.stateChangeEventListeners = stateChangeEventListeners;
        this.state = new SocketState();
    }

    SocketStateChangeResult toBeingConnect() {
        SocketStateCode nextState = SocketStateCode.BEING_CONNECT;
        return this.to(nextState);
    }

    SocketStateChangeResult toConnected() {
        SocketStateCode nextState = SocketStateCode.CONNECTED;
        return this.to(nextState);
    }

    SocketStateChangeResult toConnectFailed() {
        SocketStateCode nextState = SocketStateCode.CONNECT_FAILED;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunWithoutHandshake() {
        SocketStateCode nextState = SocketStateCode.RUN_WITHOUT_HANDSHAKE;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunSimplex() {
        SocketStateCode nextState = SocketStateCode.RUN_SIMPLEX;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunDuplex() {
        SocketStateCode nextState = SocketStateCode.RUN_DUPLEX;
        return this.to(nextState);
    }

    SocketStateChangeResult toBeingClose() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toBeingCloseByPeer() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toClosed() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toClosedByPeer() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toUnexpectedClosed() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toUnexpectedClosedByPeer() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toErrorUnknown() {
        SocketStateCode nextState = SocketStateCode.ERROR_UNKNOWN;
        return this.to(nextState);
    }

    private SocketStateChangeResult to(SocketStateCode nextState) {
        PinpointSocket pinpointSocket = this.clientHandler.getPinpointSocket();
        this.logger.debug("{} stateTo() started. to:{}", (Object)this.objectName, (Object)nextState);
        SocketStateChangeResult stateChangeResult = this.state.to(nextState);
        if (stateChangeResult.isChange()) {
            this.executeChangeEventHandler(pinpointSocket, nextState);
        }
        this.logger.info("{} stateTo() completed. {}", (Object)this.objectName, (Object)stateChangeResult);
        return stateChangeResult;
    }

    private void executeChangeEventHandler(PinpointSocket pinpointSocket, SocketStateCode nextState) {
        for (StateChangeEventListener eachListener : this.stateChangeEventListeners) {
            try {
                eachListener.stateUpdated(pinpointSocket, nextState);
            }
            catch (Exception e) {
                this.logger.warn("Please handling exception in stateUpdated method. message:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    boolean isBeforeConnected(SocketStateCode currentStateCode) {
        return SocketStateCode.isBeforeConnected(currentStateCode);
    }

    boolean isEnableCommunication() {
        return SocketStateCode.isRun(this.getCurrentStateCode());
    }

    boolean isEnableCommunication(SocketStateCode currentStateCode) {
        return SocketStateCode.isRun(currentStateCode);
    }

    boolean isEnableDuplexCommunication() {
        return SocketStateCode.isRunDuplex(this.getCurrentStateCode());
    }

    boolean isClosed() {
        return SocketStateCode.isClosed(this.getCurrentStateCode());
    }

    boolean isClosed(SocketStateCode currentStateCode) {
        return SocketStateCode.isClosed(currentStateCode);
    }

    boolean onClose(SocketStateCode currentStateCode) {
        return SocketStateCode.onClose(currentStateCode);
    }

    boolean isReconnect(SocketStateCode currentStateCode) {
        if (currentStateCode == SocketStateCode.BEING_CLOSE_BY_SERVER) {
            return true;
        }
        if (currentStateCode == SocketStateCode.CLOSED_BY_SERVER) {
            return true;
        }
        return currentStateCode == SocketStateCode.UNEXPECTED_CLOSE_BY_SERVER;
    }

    SocketStateCode getCurrentStateCode() {
        return this.state.getCurrentState();
    }

    public String toString() {
        return this.state.toString();
    }
}

