/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.HandshakeResponseCode;
import com.navercorp.pinpoint.rpc.packet.PingPayloadPacket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.server.PinpointServer;
import com.navercorp.pinpoint.rpc.server.ServerMessageListener;
import com.navercorp.pinpoint.rpc.server.ServerMessageListenerFactory;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingServerMessageListenerFactory
implements ServerMessageListenerFactory {
    private final boolean enableDuplex;

    public LoggingServerMessageListenerFactory() {
        this(false);
    }

    public LoggingServerMessageListenerFactory(boolean enableDuplex) {
        this.enableDuplex = enableDuplex;
    }

    public ServerMessageListener create() {
        return new LoggingServerMessageListener(this.enableDuplex);
    }

    private static class LoggingServerMessageListener
    implements ServerMessageListener {
        private final Logger logger = LogManager.getLogger(this.getClass());
        private final boolean enableDuplex;

        public LoggingServerMessageListener(boolean enableDuplex) {
            this.enableDuplex = enableDuplex;
        }

        @Override
        public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
            this.logger.info("handleSend packet:{}, remote:{}", (Object)sendPacket, (Object)pinpointSocket.getRemoteAddress());
        }

        @Override
        public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
            this.logger.info("handleRequest packet:{}, remote:{}", (Object)requestPacket, (Object)pinpointSocket.getRemoteAddress());
            pinpointSocket.response(requestPacket.getRequestId(), new byte[0]);
        }

        @Override
        public HandshakeResponseCode handleHandshake(Map<?, ?> properties) {
            this.logger.info("handleHandshake properties:{}", properties);
            if (this.enableDuplex) {
                return HandshakeResponseCode.DUPLEX_COMMUNICATION;
            }
            return HandshakeResponseCode.SIMPLEX_COMMUNICATION;
        }

        @Override
        public void handlePing(PingPayloadPacket pingPacket, PinpointServer pinpointServer) {
            this.logger.info("handlePing packet:{}, remote:{}", (Object)pingPacket, (Object)pinpointServer.getRemoteAddress());
        }
    }
}

