/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreateFailPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPingPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamResponsePacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelEventHandler;
import com.navercorp.pinpoint.rpc.stream.NettyClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannel;
import com.navercorp.pinpoint.rpc.stream.StreamChannelRepository;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import com.navercorp.pinpoint.rpc.util.IDGenerator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class StreamChannelManager {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Channel channel;
    private final IDGenerator idGenerator;
    private final ServerStreamChannelMessageHandler streamChannelMessageHandler;
    private final StreamChannelRepository streamChannelRepository = new StreamChannelRepository();

    public StreamChannelManager(Channel channel, IDGenerator idGenerator, ServerStreamChannelMessageHandler streamChannelMessageHandler) {
        this.channel = Objects.requireNonNull(channel, "Channel");
        this.idGenerator = Objects.requireNonNull(idGenerator, "IDGenerator");
        this.streamChannelMessageHandler = Objects.requireNonNull(streamChannelMessageHandler, "streamChannelMessageHandler");
    }

    public ClientStreamChannel openStream(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler) throws StreamException {
        this.logger.info("Open streamChannel initialization started. Channel:{} ", (Object)this.channel);
        NettyClientStreamChannel newStreamChannel = this.createNewStreamChannel(streamChannelEventHandler);
        try {
            newStreamChannel.init();
            newStreamChannel.connect(payload);
            return newStreamChannel;
        }
        catch (StreamException e) {
            newStreamChannel.close(e.getStreamCode());
            throw e;
        }
    }

    public ClientStreamChannel openStreamAndAwait(byte[] payload, ClientStreamChannelEventHandler streamChannelEventHandler, long timeout) throws StreamException {
        this.logger.info("Open streamChannel initialization started. Channel:{} ", (Object)this.channel);
        NettyClientStreamChannel newStreamChannel = this.createNewStreamChannel(streamChannelEventHandler);
        try {
            newStreamChannel.init();
            newStreamChannel.connectAndAwait(payload, timeout);
            return newStreamChannel;
        }
        catch (StreamException e) {
            newStreamChannel.close(e.getStreamCode());
            throw e;
        }
    }

    private NettyClientStreamChannel createNewStreamChannel(ClientStreamChannelEventHandler streamChannelEventHandler) {
        int streamChannelId = this.idGenerator.generate();
        return new NettyClientStreamChannel(this.channel, streamChannelId, this.streamChannelRepository, streamChannelEventHandler);
    }

    public void messageReceived(StreamPacket packet) {
        int streamChannelId = packet.getStreamChannelId();
        short packetType = packet.getPacketType();
        this.logger.debug("StreamChannel message received. (Channel:{}, StreamId:{}, Packet:{}).", (Object)this.channel, (Object)streamChannelId, (Object)packet);
        if (10 == packetType) {
            this.handleCreate((StreamCreatePacket)packet);
            return;
        }
        StreamChannel streamChannel = this.streamChannelRepository.getStreamChannel(streamChannelId);
        if (streamChannel == null) {
            if (15 != packetType) {
                this.write(new StreamClosePacket(streamChannelId, StreamCode.ID_NOT_FOUND));
            }
        } else if (streamChannel instanceof ServerStreamChannel) {
            this.messageReceived((ServerStreamChannel)streamChannel, packet);
        } else if (streamChannel instanceof ClientStreamChannel) {
            this.messageReceived((ClientStreamChannel)streamChannel, packet);
        } else {
            streamChannel.close(StreamCode.UNKNWON_ERROR);
        }
    }

    private void write(StreamPacket streamPacket) {
        if (this.channel.isConnected()) {
            this.channel.write((Object)streamPacket);
        }
    }

    private void messageReceived(ServerStreamChannel serverStreamChannel, StreamPacket packet) {
        short packetType = packet.getPacketType();
        switch (packetType) {
            case 15: {
                serverStreamChannel.handleStreamClosePacket((StreamClosePacket)packet);
                break;
            }
            case 17: {
                this.handlePing(serverStreamChannel, (StreamPingPacket)packet);
                break;
            }
            case 18: {
                break;
            }
            default: {
                serverStreamChannel.close(StreamCode.PACKET_UNKNOWN);
                this.logger.info("Unknown StreamPacket received streamChannel:{}, Packet;{}.", (Object)serverStreamChannel, (Object)packet);
            }
        }
    }

    private void messageReceived(ClientStreamChannel clientStreamChannel, StreamPacket packet) {
        short packetType = packet.getPacketType();
        try {
            switch (packetType) {
                case 12: {
                    boolean connected = clientStreamChannel.changeStateConnected();
                    if (!connected) {
                        clientStreamChannel.close(StreamCode.STATE_NOT_CONNECTED);
                    }
                    break;
                }
                case 14: {
                    clientStreamChannel.disconnect(((StreamCreateFailPacket)packet).getCode());
                    break;
                }
                case 20: {
                    clientStreamChannel.handleStreamResponsePacket((StreamResponsePacket)packet);
                    break;
                }
                case 15: {
                    clientStreamChannel.handleStreamClosePacket((StreamClosePacket)packet);
                    break;
                }
                case 17: {
                    this.handlePing(clientStreamChannel, (StreamPingPacket)packet);
                    break;
                }
                case 18: {
                    break;
                }
                default: {
                    clientStreamChannel.close(StreamCode.PACKET_UNKNOWN);
                    this.logger.info("Unknown StreamPacket received streamChannel:{}, Packet;{}.", (Object)clientStreamChannel, (Object)packet);
                    break;
                }
            }
        }
        catch (StreamException e) {
            clientStreamChannel.close(e.getStreamCode());
        }
    }

    private void handleCreate(StreamCreatePacket packet) {
        int streamChannelId = packet.getStreamChannelId();
        ServerStreamChannel streamChannel = new ServerStreamChannel(this.channel, streamChannelId, this.streamChannelRepository, this.streamChannelMessageHandler);
        try {
            streamChannel.init();
            streamChannel.handleStreamCreatePacket(packet);
        }
        catch (StreamException e) {
            streamChannel.close(e.getStreamCode());
        }
    }

    private void handlePing(StreamChannel streamChannel, StreamPingPacket packet) {
        try {
            streamChannel.sendPong(packet.getRequestId());
        }
        catch (PinpointSocketException e) {
            streamChannel.close(StreamCode.STATE_NOT_CONNECTED);
        }
    }

    public void close() {
        this.streamChannelRepository.close(StreamCode.STATE_CLOSED);
    }
}

