/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.apache.eventmesh.storage.mongodb.producer.MongodbReplicaSetProducer;
import org.apache.eventmesh.storage.mongodb.producer.MongodbStandaloneProducer;

@Config(field="configurationHolder")
public class MongodbProducer
implements Producer {
    private ConfigurationHolder configurationHolder;
    private Producer producer;

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer.isClosed();
    }

    public void start() {
        this.producer.start();
    }

    public void shutdown() {
        this.producer.shutdown();
    }

    public void init(Properties properties) throws Exception {
        String connectorType = this.configurationHolder.getConnectorType();
        if (connectorType.equals("STANDALONE")) {
            this.producer = new MongodbStandaloneProducer(this.configurationHolder);
        }
        if (connectorType.equals("REPLICA_SET")) {
            this.producer = new MongodbReplicaSetProducer(this.configurationHolder);
        }
        this.producer.init(properties);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        this.producer.publish(cloudEvent, sendCallback);
    }

    public void sendOneway(CloudEvent cloudEvent) {
        this.producer.sendOneway(cloudEvent);
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.producer.request(cloudEvent, rrCallback, timeout);
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        return this.producer.reply(cloudEvent, sendCallback);
    }

    public void checkTopicExist(String topic) throws Exception {
        this.producer.checkTopicExist(topic);
    }

    public void setExtFields() {
        this.producer.setExtFields();
    }
}

