/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.enums.HttpMethod;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.response.Error;
import org.apache.eventmesh.runtime.admin.response.GetRegistryResponse;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/registry")
public class RegistryHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(RegistryHandler.class);
    private final Registry eventMeshRegistry;

    public RegistryHandler(Registry eventMeshRegistry, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshRegistry = eventMeshRegistry;
    }

    void preflight(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream out = httpExchange.getResponseBody();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void get(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            ArrayList<GetRegistryResponse> getRegistryResponseList = new ArrayList<GetRegistryResponse>();
            List<EventMeshDataInfo> eventMeshDataInfos = this.eventMeshRegistry.findAllEventMeshInfo();
            for (EventMeshDataInfo eventMeshDataInfo : eventMeshDataInfos) {
                GetRegistryResponse getRegistryResponse = new GetRegistryResponse(eventMeshDataInfo.getEventMeshClusterName(), eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint(), eventMeshDataInfo.getLastUpdateTimestamp(), eventMeshDataInfo.getMetadata().toString());
                getRegistryResponseList.add(getRegistryResponse);
            }
            getRegistryResponseList.sort(Comparator.comparing(GetRegistryResponse::getEventMeshClusterName));
            String result = JsonUtils.toJSONString(getRegistryResponseList);
            httpExchange.sendResponseHeaders(200, Objects.requireNonNull(result).getBytes(Constants.DEFAULT_CHARSET).length);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (NullPointerException e) {
            String result = JsonUtils.toJSONString(new ArrayList());
            httpExchange.sendResponseHeaders(200, Objects.requireNonNull(result).getBytes(Constants.DEFAULT_CHARSET).length);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJSONString((Object)error);
            httpExchange.sendResponseHeaders(500, Objects.requireNonNull(result).getBytes(Constants.DEFAULT_CHARSET).length);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        switch (HttpMethod.valueOf((String)httpExchange.getRequestMethod())) {
            case OPTIONS: {
                this.preflight(httpExchange);
                break;
            }
            case GET: {
                this.get(httpExchange);
                break;
            }
        }
    }
}

