/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.registry.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(HelloTask.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private final Acl acl;

    public HelloTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
        this.acl = eventMeshTCPServer.getAcl();
    }

    @Override
    public void run() {
        final long taskExecuteTime = System.currentTimeMillis();
        final Package res = new Package();
        Session session = null;
        final UserAgent user = (UserAgent)this.pkg.getBody();
        try {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(this.ctx.channel());
            String group = user.getGroup();
            String token = user.getToken();
            String subsystem = user.getSubsystem();
            if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable()) {
                EventMeshAppSubTopicInfo eventMeshAppSubTopicInfo = this.eventMeshTCPServer.getRegistry().findEventMeshAppSubTopicInfo(group);
                if (eventMeshAppSubTopicInfo == null) {
                    throw new AclException("no group register");
                }
                this.acl.doAclCheckInTcpConnect(remoteAddr, token, subsystem, eventMeshAppSubTopicInfo);
            }
            if (this.eventMeshTCPServer.getEventMeshServer().getServiceState() != ServiceState.RUNNING) {
                log.error("server state is not running:{}", (Object)this.eventMeshTCPServer.getEventMeshServer().getServiceState());
                throw new Exception("server state is not running, maybe deploying...");
            }
            this.validateUserAgent(user);
            session = this.eventMeshTCPServer.getClientSessionGroupMapping().createSession(user, this.ctx);
            res.setHeader(new Header(Command.HELLO_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
            Utils.writeAndFlush(res, this.startTime, taskExecuteTime, session.getContext(), session);
        }
        catch (Throwable e) {
            MESSAGE_LOGGER.error("HelloTask failed|address={},errMsg={}", (Object)this.ctx.channel().remoteAddress(), (Object)e);
            res.setHeader(new Header(Command.HELLO_RESPONSE, OPStatus.FAIL.getCode().intValue(), Arrays.toString(e.getStackTrace()), this.pkg.getHeader().getSeq()));
            this.ctx.writeAndFlush((Object)res).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        Utils.logFailedMessageFlow(future, res, user, HelloTask.this.startTime, taskExecuteTime);
                    } else {
                        Utils.logSucceedMessageFlow(res, user, HelloTask.this.startTime, taskExecuteTime);
                    }
                    log.warn("HelloTask failed,close session,addr:{}", (Object)HelloTask.this.ctx.channel().remoteAddress());
                    HelloTask.this.eventMeshTCPServer.getClientSessionGroupMapping().closeSession(HelloTask.this.ctx);
                }
            });
        }
    }

    private void validateUserAgent(UserAgent user) throws Exception {
        if (user == null) {
            throw new Exception("client info cannot be null");
        }
        if (user.getVersion() == null) {
            throw new Exception("client version cannot be null");
        }
        if (!StringUtils.equalsAny((CharSequence)user.getPurpose(), (CharSequence[])new CharSequence[]{"pub", "sub"})) {
            throw new Exception("client purpose config is error");
        }
        if (StringUtils.isBlank((CharSequence)user.getGroup())) {
            throw new Exception("client group cannot be null");
        }
    }
}

