/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeTask
extends AbstractTask {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");

    public UnSubscribeTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            Session session = this.session;
            synchronized (session) {
                ConcurrentHashMap<String, SubscriptionItem> subscribeTopics = this.session.getSessionContext().getSubscribeTopics();
                if (MapUtils.isNotEmpty(subscribeTopics)) {
                    ArrayList<SubscriptionItem> topics = new ArrayList<SubscriptionItem>(subscribeTopics.values());
                    this.session.unsubscribe(topics);
                    MESSAGE_LOGGER.info("UnSubscriberTask succeed|user={}|topics={}", (Object)this.session.getClient(), topics);
                }
            }
            msg.setHeader(new Header(Command.UNSUBSCRIBE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            MESSAGE_LOGGER.error("UnSubscribeTask failed|user={}|errMsg={}", (Object)this.session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.UNSUBSCRIBE_RESPONSE, OPStatus.FAIL.getCode().intValue(), "exception while unSubscribing", this.pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(msg, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
        }
    }
}

