/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.DefaultReference;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAsyncTraceContext
implements AsyncTraceContext {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final Reference<Trace> EMPTY = DefaultReference.emptyReference();
    private final Provider<BaseTraceFactory> baseTraceFactoryProvider;
    private final Binder<Trace> binder;

    public DefaultAsyncTraceContext(Provider<BaseTraceFactory> baseTraceFactoryProvider, Binder<Trace> binder) {
        this.baseTraceFactoryProvider = Objects.requireNonNull(baseTraceFactoryProvider, "baseTraceFactoryProvider");
        this.binder = Objects.requireNonNull(binder, "binder");
    }

    @Override
    public Reference<Trace> continueAsyncContextTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId, boolean canSampled) {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.newAsyncContextTraceObject(traceRoot, localAsyncId, canSampled);
        this.bind(reference, trace);
        return reference;
    }

    @Override
    public Trace newAsyncContextTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId, boolean canSampled) {
        BaseTraceFactory baseTraceFactory = (BaseTraceFactory)this.baseTraceFactoryProvider.get();
        return baseTraceFactory.continueAsyncContextTraceObject(traceRoot, localAsyncId, canSampled);
    }

    @Override
    public Reference<Trace> currentRawTraceObject() {
        return this.binder.get();
    }

    @Override
    public Reference<Trace> currentTraceObject() {
        Reference<Trace> reference = this.binder.get();
        Trace trace = reference.get();
        if (trace == null) {
            return EMPTY;
        }
        if (trace.canSampled()) {
            return reference;
        }
        return EMPTY;
    }

    @Override
    public void removeTraceObject() {
        this.binder.remove();
    }

    private Reference<Trace> checkAndGet() {
        Reference<Trace> reference = this.binder.get();
        Trace old = reference.get();
        if (old != null) {
            PinpointException exception = new PinpointException("already Trace Object exist.");
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("beforeTrace:{}", (Object)old, (Object)exception);
            }
            throw exception;
        }
        return reference;
    }

    private void bind(Reference<Trace> reference, Trace trace) {
        reference.set(trace);
    }
}

