/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import java.util.Objects;

public class DisableAsyncChildTrace
implements Trace {
    public static final String UNSUPPORTED_OPERATION = "disable async child trace";
    private boolean closed = false;
    private DefaultTraceScopePool scopePool;
    private final TraceRoot traceRoot;
    private final LocalAsyncId localAsyncId;

    public DisableAsyncChildTrace(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.localAsyncId = Objects.requireNonNull(localAsyncId, "localAsyncId");
    }

    public SpanEventRecorder traceBlockBegin() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public void traceBlockEnd(int stackId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean isRootStack() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public int getCallStackFrameId() {
        return 0;
    }

    private TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.getTraceRoot().getTraceStartTime();
    }

    public TraceId getTraceId() {
        return this.getTraceRoot().getTraceId();
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return this.getTraceId().isRoot();
    }

    public boolean isAsync() {
        return true;
    }

    public SpanRecorder getSpanRecorder() {
        return null;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }

    public String toString() {
        return "DisableAsyncChildTrace{traceRoot=" + this.getTraceRoot() + ", localAsyncId=" + this.localAsyncId + '}';
    }
}

